Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.

Lemma val_rel_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (v₁ v₂ : value V),
  val_rel R _ v₁ v₂ → val_rel S _ v₁ v₂.
Proof.
intros HRS V v₁ v₂; unfold val_rel; apply HRS.
Qed.

Lemma ectx_rel_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (E₁ E₂ : ectx V),
  ectx_rel R _ E₁ E₂ → ectx_rel S _ E₁ E₂.
Proof.
intros HRS V E₁ E₂; unfold ectx_rel; apply HRS.
Qed.

Lemma passive_step_monotone : monotone passive_step.
Proof.
intros R S HRS V t₁ t₂ Hpas; split.
+ apply HRS, Hpas.
+ intros v Heq; apply Hpas in Heq; destruct Heq as [v₂ [ Hred Hv ] ].
  exists v₂; firstorder.
Qed.

Lemma active_step_monotone : monotone active_step.
Proof.
intros R S HRS V t₁ t₂ Hact; split.
+ apply HRS, Hact.
+ intros t₁' Hred; apply Hact in Hred; destruct Hred as [ t₂' [ Hred' Ht' ] ].
  exists t₂'; firstorder.
+ intros E₁ x v₁ Heq.
  apply Hact in Heq; destruct Heq as [ E₂ [ v₂ H ] ].
  exists E₂; exists v₂; firstorder.
Qed.

Lemma var_monotone : monotone var.
Proof.
intros R S Hsub V _ _ [ x ]; constructor.
Qed.

Lemma var2_monotone : monotone var2.
Proof.
intros R S Hsub V _ _ []; intros; constructor.
Qed.

Lemma lam_monotone : monotone lam.
Proof.
intros R S Hsub V _ _ []; intros; constructor; apply Hsub; assumption.
Qed.

Lemma app_monotone : monotone app.
Proof.
intros R S Hsub V _ _ [ t₁ t₂ s₁ s₂ Ht Hs ]; constructor;
  apply Hsub; assumption.
Qed.

Lemma subst_monotone : monotone subst.
Proof.
intros R S Hsub V _ _ [ t₁ t₂ v₁ v₂ Ht Hv ]; constructor.
+ apply Hsub; assumption.
+ apply (val_rel_monotone Hsub); assumption.
Qed.

Lemma ectxr_monotone : monotone ectxr.
Proof.
intros R S Hsub V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; constructor.
+ apply (ectx_rel_monotone Hsub); assumption.
+ apply Hsub; assumption.
Qed.

Lemma map_monotone : monotone map.
Proof.
intros R S Hsub V _ _ [ W t₁ t₂ Ht ];
constructor; apply Hsub; assumption.
Qed.

Lemma redr_monotone : monotone redr.
Proof.
intros R S Hsub V t₁ t₂ []; intros; econstructor; try eassumption.
apply Hsub; assumption.
Qed.