Require Import Utf8.
Require Import Lang.

Fixpoint tmonad_map_id {A : Set} (t : term A) :
  ∀ (f : A → A), (∀ x, f x = x) → tmap f t = t
with vmonad_map_id {A : Set} (v : value A) :
  ∀ (f : A → A), (∀ x, f x = x) → vmap f v = v.
Proof.
+ intros f Hf; destruct t as [ v | t s ]; simpl.
  - rewrite vmonad_map_id; [ reflexivity | assumption ].
  - rewrite tmonad_map_id; [ | assumption ].
    rewrite tmonad_map_id; [ | assumption ].
    reflexivity.
+ intros f Hf; destruct v as [ x | t ]; simpl.
  rewrite Hf; reflexivity.
  rewrite tmonad_map_id; [ reflexivity | ].
  intros [ | x ]; simpl; [ reflexivity | ].
  rewrite Hf; reflexivity.
Qed.

Lemma emonad_map_id {A : Set} (E : ectx A) :
  ∀ (f : A → A), (∀ x, f x = x) → emap f E = E.
Proof.
intros f Hf; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE, tmonad_map_id; auto.
+ rewrite IHE, vmonad_map_id; auto.
Qed.

Lemma tmonad_map_id' {A : Set} (t : term A) :
  tmap (λ x, x) t = t.
Proof.
apply tmonad_map_id; reflexivity.
Qed.

Lemma vmonad_map_id' {A : Set} (v : value A) :
  vmap (λ x, x) v = v.
Proof.
apply vmonad_map_id; reflexivity.
Qed.

Lemma emonad_map_id' {A : Set} (E : ectx A) :
  emap (λ x, x) E = E.
Proof.
apply emonad_map_id; reflexivity.
Qed.

Fixpoint tmonad_map_map {A B C : Set} (t : term A) :
  ∀ (f₁ : A → B) (f₂ : B → C) (f : A → C),
  (∀ x, f₂ (f₁ x) = f x) →
  tmap f₂ (tmap f₁ t) = tmap f t
with vmonad_map_map {A B C : Set} (v : value A) :
  ∀ (f₁ : A → B) (f₂ : B → C) (f : A → C),
  (∀ x, f₂ (f₁ x) = f x) →
  vmap f₂ (vmap f₁ v) = vmap f v.
Proof.
+ intros f₁ f₂ f Hf; destruct t as [ v | t s ]; simpl.
  - erewrite vmonad_map_map; [ reflexivity | eassumption ].
  - erewrite tmonad_map_map; [ | eassumption ].
    erewrite tmonad_map_map; [ | eassumption ].
    reflexivity.
+ intros f₁ f₂ f Hf; destruct v as [ x | t ]; simpl.
  - rewrite Hf; reflexivity.
  - erewrite tmonad_map_map; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    rewrite Hf; reflexivity.
Qed.

Lemma emonad_map_map {A B C : Set} (E : ectx A) :
  ∀ (f₁ : A → B) (f₂ : B → C) (f : A → C),
  (∀ x, f₂ (f₁ x) = f x) →
  emap f₂ (emap f₁ E) = emap f E.
Proof.
intros f₁ f₂ f Hf; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ erewrite IHE, tmonad_map_map; [ reflexivity | eassumption ].
+ erewrite IHE, vmonad_map_map; [ reflexivity | eassumption ].
Qed.

Lemma tmonad_map_map' {A B C : Set} (t : term A) :
  ∀ (f₁ : A → B) (f₂ : B → C),
  tmap f₂ (tmap f₁ t) = tmap (λ x, f₂ (f₁ x)) t.
Proof.
intros; apply tmonad_map_map; reflexivity.
Qed.

Lemma vmonad_map_map' {A B C : Set} (v : value A) :
  ∀ (f₁ : A → B) (f₂ : B → C),
  vmap f₂ (vmap f₁ v) = vmap (λ x, f₂ (f₁ x)) v.
Proof.
intros; apply vmonad_map_map; reflexivity.
Qed.

Lemma emonad_map_map' {A B C : Set} (E : ectx A) :
  ∀ (f₁ : A → B) (f₂ : B → C),
  emap f₂ (emap f₁ E) = emap (λ x, f₂ (f₁ x)) E.
Proof.
intros; apply emonad_map_map; reflexivity.
Qed.

Fixpoint tmonad_bind_map {A B B' C : Set} (t : term A) :
  ∀ (f₁ : A → B) (f₂ : B → value C) (g₁ : A → value B') (g₂ : B' → C),
  (∀ x, f₂ (f₁ x) = vmap g₂ (g₁ x)) →
  tbind f₂ (tmap f₁ t) = tmap g₂ (tbind g₁ t)
with vmonad_bind_map {A B B' C : Set} (v : value A) :
  ∀ (f₁ : A → B) (f₂ : B → value C) (g₁ : A → value B') (g₂ : B' → C),
  (∀ x, f₂ (f₁ x) = vmap g₂ (g₁ x)) →
  vbind f₂ (vmap f₁ v) = vmap g₂ (vbind g₁ v).
Proof.
+ intros f₁ f₂ g₁ g₂ Hfg; destruct t as [ v | t s ]; simpl.
  - erewrite vmonad_bind_map; [ | eassumption ]; reflexivity.
  - erewrite tmonad_bind_map; [ | eassumption ].
    erewrite tmonad_bind_map; [ | eassumption ].
    reflexivity.
+ intros f₁ f₂ g₁ g₂ Hfg; destruct v as [ x | t ]; simpl.
  - apply Hfg.
  - erewrite tmonad_bind_map; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    rewrite Hfg, vmonad_map_map'.
    symmetry; apply vmonad_map_map; reflexivity.
Qed.

Lemma emonad_bind_map {A B B' C : Set} (E : ectx A) :
  ∀ (f₁ : A → B) (f₂ : B → value C) (g₁ : A → value B') (g₂ : B' → C),
  (∀ x, f₂ (f₁ x) = vmap g₂ (g₁ x)) →
  ebind f₂ (emap f₁ E) = emap g₂ (ebind g₁ E).
Proof.
intros f₁ f₂ g₁ g₂ Hfg; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; erewrite tmonad_bind_map; [ | eassumption ].
  reflexivity.
+ rewrite IHE; erewrite vmonad_bind_map; [ | eassumption ].
  reflexivity.
Qed.

Fixpoint tmonad_bind_bind {A B B' C : Set} (t : term A) :
  ∀ (f₁ : A → value B) (f₂ : B → value C)
    (g₁ : A → value B') (g₂ : B' → value C),
  (∀ x, vbind f₂ (f₁ x) = vbind g₂ (g₁ x)) →
  tbind f₂ (tbind f₁ t) = tbind g₂ (tbind g₁ t)
with vmonad_bind_bind {A B B' C : Set} (v : value A) :
  ∀ (f₁ : A → value B) (f₂ : B → value C)
    (g₁ : A → value B') (g₂ : B' → value C),
  (∀ x, vbind f₂ (f₁ x) = vbind g₂ (g₁ x)) →
  vbind f₂ (vbind f₁ v) = vbind g₂ (vbind g₁ v).
Proof.
+ intros f₁ f₂ g₁ g₂ Hfg; destruct t as [ v | t s ]; simpl.
  - erewrite vmonad_bind_bind; [ | eassumption ]; reflexivity.
  - erewrite (tmonad_bind_bind _ _ _ _ t f₁ f₂); [ | eassumption ].
    erewrite (tmonad_bind_bind _ _ _ _ s f₁ f₂); [ | eassumption ].
    reflexivity.
+ intros f₁ f₂ g₁ g₂ Hfg; destruct v as [ x | t ]; simpl.
  - apply Hfg.
  - erewrite tmonad_bind_bind; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    erewrite (vmonad_bind_map (f₁ x) _ _ f₂); simpl; [ | reflexivity ].
    rewrite Hfg.
    symmetry; apply vmonad_bind_map; reflexivity.
Qed.

Fixpoint tmonad_bind_return {A : Set} (t : term A) :
  ∀ (f : A → value A), (∀ x, f x = val_var x) → tbind f t = t
with vmonad_bind_return {A : Set} (v : value A) :
  ∀ (f : A → value A), (∀ x, f x = val_var x) → vbind f v = v.
Proof.
+ intros f Hf; destruct t as [ v | t s ]; simpl.
  - rewrite vmonad_bind_return; [ reflexivity | assumption ].
  - rewrite tmonad_bind_return; [ | assumption ].
    rewrite tmonad_bind_return; [ | assumption ].
    reflexivity.
+ intros f Hf; destruct v as [ x | t ]; simpl.
  - apply Hf.
  - rewrite tmonad_bind_return; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    rewrite Hf; reflexivity.
Qed.

Lemma emonad_bind_return {A : Set} (E : ectx A) :
  ∀ (f : A → value A), (∀ x, f x = val_var x) → ebind f E = E.
Proof.
intros f Hf; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE, tmonad_bind_return; auto.
+ rewrite IHE, vmonad_bind_return; auto.
Qed.

Lemma tmonad_bind_return' {A : Set} (t : term A) :
  tbind (@val_var A) t = t.
Proof.
apply tmonad_bind_return; reflexivity.
Qed.

Lemma vmonad_bind_return' {A : Set} (v : value A) :
  vbind (@val_var A) v = v.
Proof.
apply vmonad_bind_return; reflexivity.
Qed.

Lemma emonad_bind_return' {A : Set} (E : ectx A) :
  ebind (@val_var A) E = E.
Proof.
apply emonad_bind_return; reflexivity.
Qed.

Lemma subst_vshift {V : Set} (v w : value V) :
  vshift v {v↦ w} = v.
Proof.
erewrite vmonad_bind_map.
+ rewrite vmonad_map_id'; apply vmonad_bind_return'.
+ intro x; reflexivity.
Qed.

Lemma subst_eshift {V : Set} E (v : value V) :
  eshift E {E↦ v} = E.
Proof.
erewrite emonad_bind_map.
+ rewrite emonad_map_id'; apply emonad_bind_return'.
+ intro x; reflexivity.
Qed.

Lemma map_eplug {A B : Set} (f : A → B) (E : ectx A) (t : term A) :
  tmap f (E $[ t ]) = emap f E $[ tmap f t ].
Proof.
induction E as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity.
Qed.

Lemma bind_eplug {A B : Set} (f : A → value B) (E : ectx A) (t : term A) :
  tbind f (E $[ t ]) = ebind f E $[ tbind f t ].
Proof.
induction E as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity.
Qed.

Lemma map_ecomp {A B : Set} (f : A → B) (E E' : ectx A) :
  emap f (ecomp E E') = ecomp (emap f E) (emap f E').
Proof.
induction E as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity.
Qed.

Lemma ecomp_eplug {V : Set} (E₁ E₂ : ectx V) (t : term V) :
  (ecomp E₁ E₂) $[ t ] = E₁ $[ E₂ $[ t ] ].
Proof.
induction E₁ as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity.
Qed.