Require Import Utf8.
Require Import Lang.

Inductive ctx : Set → Type :=
| ctx_hole : ctx Empty_set
| ctx_lam  : ∀ V : Set, ctx V → ctx (inc V)
| ctx_app1 : ∀ V : Set, ctx V → term V → ctx V
| ctx_app2 : ∀ V : Set, term V → ctx V → ctx V
.

Arguments ctx_lam  [V] _.
Arguments ctx_app1 [V] _ _.
Arguments ctx_app2 [V] _ _.

Fixpoint plug {V : Set} (C : ctx V) : term V → term0 :=
  match C in ctx V return term V → term Empty_set with
  | ctx_hole     => λ t, t
  | ctx_lam  C   => λ t, plug C (val_lam t)
  | ctx_app1 C s => λ t, plug C (tm_app t s)
  | ctx_app2 s C => λ t, plug C (tm_app s t)
  end.

Definition ctx_approx (V : Set) (t₁ t₂ : term V) : Prop :=
  ∀ (C : ctx V) (v₁ : value0), red_rtc (plug C t₁) v₁ →
  ∃ (v₂ : value0), red_rtc (plug C t₂) v₂.