Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import LangProperties.

Lemma lam_passive_evolution {R Q S : term_rel} :
  R ↣ Q & S → lam R ⊆ passive_step ((lam ∪ redr) Q).
Proof.
intros HRQS V _ _ [ t₁ t₂ Ht ]; split.
+ left; constructor; apply (progress_sub_passive HRQS); assumption.
+ intros v₁ Heq; injection Heq; clear Heq; intro Heq; subst.
  exists (val_lam t₂); split; [ constructor 1 | ].
  unfold val_rel; right; econstructor.
  - simpl; econstructor 2; [ | constructor 1 ]; apply red_beta.
  - simpl; econstructor 2; [ | constructor 1 ]; apply red_beta.
  - erewrite tmonad_bind_map, tmonad_bind_map, tmonad_map_id', tmonad_map_id',
      tmonad_bind_return', tmonad_bind_return'.
    * apply (progress_sub_passive HRQS); assumption.
    * intros [ | x ]; reflexivity.
    * intros [ | x ]; reflexivity.
Qed.

Lemma lam_active_evolution {R Q S : term_rel} :
  R ↣ Q & S → lam R ⊆ active_step (lam S).
Proof.
intros HRQS V _ _ [ t₁ t₂ Ht ]; split.
+ constructor; apply (progress_sub_active HRQS); assumption.
+ intros ? Hred; inversion Hred.
+ intros E₁ x v₁ Heq; destruct E₁; discriminate.
Qed.

Lemma lam_evolution : lam !↝ (lam ∪ redr) & lam.
Proof.
intros R Q S HRQS; split.
+ apply (lam_passive_evolution HRQS).
+ apply (lam_active_evolution HRQS).
Qed.