Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import Reduction LangProperties Monotonicity.
Require Import UpToMap UpToSubst.

Definition ectxr_act : term_rel → term_rel :=
  (ectxr ∪ (ectxr ◦ map)) ∪ (subst_act ∪ id).

Lemma ectxr_passive_evolution (R S : term_rel) :
  R ↣ R & S →
  ectxr R ⊆ passive_step ((ectxr ∪ (subst ◦ map)) R).
Proof.
intros HRS V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; split.
+ left; constructor; assumption.
+ intros v₁ Heq; destruct E₁; try discriminate.
  simpl in Heq; subst.
  apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₁ Hv ] ].
  unfold ectx_rel in HE; simpl in HE.
  apply (progress_value HRS) in HE; destruct HE as [ u [ Hred₂ Hu ] ].
  apply red_rtc_subst with (v := v₂) in Hred₂.
  rewrite bind_eplug in Hred₂; simpl in Hred₂.
  rewrite subst_eshift in Hred₂.
  exists (u {v↦ v₂}); split.
  - eapply red_rtc_trans; [ | eassumption ].
    apply red_rtc_in_ectx; assumption.
  - apply val_rel_subst with (w₁ := v₁) (w₂ := v₂) in Hu; [ | assumption ].
    simpl in Hu.
    eapply val_rel_monotone; [ | eassumption ].
    unfold trf_sum; auto.
Qed.

Lemma ectxr_active_evolution (R S : term_rel) :
  R ↣ R & S →
  ectxr R ⊆ active_step (ectxr_act S).
Proof.
intros HRS V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; split.
+ left; left; constructor.
  - eapply ectx_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
  - apply (progress_sub_active HRS); assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | E₁' x v₁ ].
  - apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₁ Hv ] ].
    unfold ectx_rel in HE.
    apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HE; [ | assumption ].
    repeat rewrite bind_eplug in HE; simpl in HE.
    repeat rewrite subst_eshift in HE.
    assert (HRS' := HRS); apply subst_evolution in HRS'.
    intros t₁' Hred; eapply (progress_step HRS') in HE; [ | eassumption ].
    destruct HE as [ t₂' [ Hred₂ Ht' ] ].
    exists t₂'; split.
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_in_ectx; assumption.
    * right; left; assumption.
  - eapply (progress_step HRS) in Ht; [ | eassumption ].
    destruct Ht as [ t₂' [ Hred₂ Ht' ] ].
    intros r Hred'.
    eapply red_determ in Hred'; [ | apply red_in_ectx; eassumption ]; subst.
    exists (E₂ $[ t₂' ]); split.
    * apply red_rtc_in_ectx; assumption.
    * left; left; constructor; [ | assumption ].
      eapply ectx_rel_monotone; [ | eassumption ].
      apply (progress_sub_active HRS).
  - intros ? Hred; rewrite <- ecomp_eplug in Hred.
    apply open_is_stuck in Hred; destruct Hred.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | E₁' x v₁ ].
  - apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₁ Hv ] ].
    unfold ectx_rel in HE.
    apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HE; [ | assumption ].
    repeat rewrite bind_eplug in HE; simpl in HE.
    repeat rewrite subst_eshift in HE.
    assert (HRS' := HRS); apply subst_evolution in HRS'.
    intros E₁' x w₁ Heq; rewrite Heq in HE.
    eapply (progress_open HRS') in HE.
    destruct HE as [ E₂' [ w₂ [ Hred₂ [ HE' Hw ] ] ] ].
    exists E₂'; exists w₂; split; [ | split ].
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_in_ectx; assumption.
    * right; left; assumption.
    * right; left; assumption.
  - intros E₁' x v₁ Heq.
    apply red_in_ectx with (E := E₁) in Hred; rewrite Heq in Hred.
    apply open_is_stuck in Hred; destruct Hred.
  - eapply (progress_open HRS) in Ht.
    destruct Ht as [ E₂' [ v₂ [ Hred₂ [ HE' Hv ] ] ] ].
    intros F₁ z w₂ Heq; symmetry in Heq.
    rewrite <- ecomp_eplug in Heq; apply open_stuck_unique in Heq.
    destruct Heq as [ ? [ ? ? ] ]; subst.
    exists (ecomp E₂ E₂'); exists v₂; split; [ | split ].
    * rewrite ecomp_eplug; apply red_rtc_in_ectx; assumption.
    * unfold ectx_rel; left; right.
      rewrite map_ecomp, map_ecomp, ecomp_eplug, ecomp_eplug.
      { constructor.
      + apply ectx_rel_map; eapply ectx_rel_monotone; [ | eassumption ].
        apply (progress_sub_active HRS).
      + apply Mk_map_id; exact HE'.
      }
    * eapply val_rel_monotone; [ | eassumption ].
      unfold ectxr_act, trf_sum; auto.
Qed.

Lemma ectxr_evolution : ectxr ↝ (ectxr ∪ (subst ◦ map)) & ectxr_act.
Proof.
intros R S HRS; split.
+ apply (ectxr_passive_evolution _ _ HRS).
+ apply ectxr_active_evolution; assumption.
Qed.