Require Import Utf8.
Require Import Lang TermRelation Simulation Reduction.
Require Import Combo CtxApprox.

Fixpoint combo_refl (R : term_rel) (V : Set) (t : term V) : combo R _ t t
with combo_refl_v (R : term_rel) (V : Set) (v : value V) : combo R _ v v.
Proof.
+ destruct t as [ v | t s ].
  - apply combo_refl_v.
  - apply (combo_app (combo R)); [ auto | ].
    constructor; apply combo_refl.
+ destruct v as [ x | t ].
  - apply (combo_var (combo R)); [ auto | ].
    constructor.
  - apply (combo_lam (combo R)); [ auto | ].
    constructor; apply combo_refl.
Qed.

Lemma precongruence (R : term_rel) (V : Set) (C : ctx V) (t₁ t₂ : term V) :
  combo R _ t₁ t₂ → combo R _ (plug C t₁) (plug C t₂).
Proof.
generalize t₁ t₂; clear t₁ t₂; induction C; simpl; intros t₁ t₂ Ht.
+ assumption.
+ apply IHC; apply (combo_lam (combo R)); [ auto | ].
  constructor; assumption.
+ apply IHC; apply (combo_app (combo R)); [ auto | ].
  constructor; [ assumption | apply combo_refl ].
+ apply IHC; apply (combo_app (combo R)); [ auto | ].
  constructor; [ apply combo_refl | assumption ].
Qed.

Lemma adequacy (R : term_rel) (t₁ t₂ : term0) :
  (R ↣ R & R) → R _ t₁ t₂ →
  ∀ v₁ : value0, red_rtc t₁ v₁ → ∃ v₂ : value0, red_rtc t₂ v₂.
Proof.
intros Hsim Ht v₁ Hred.
destruct (exist (λ t₁' : term0, t₁' = v₁) _ eq_refl) as [ t₁' Heq ].
rewrite <- Heq in Hred; generalize Heq t₂ Ht; clear Heq t₂ Ht.
induction Hred as [ t₁ | t₁ t₁' t₁'' Hred Hrtc IH ]; intros Heq t₂ Ht.
+ rewrite Heq in Ht; apply (pt_passive _ _ _ Hsim) in Ht.
  destruct Ht as [ _ Ht ].
  specialize (Ht _ eq_refl).
  destruct Ht as [ v₂ [ Hred₂ _ ] ]; exists v₂; assumption.
+ apply (pt_active _ _ _ Hsim) in Ht.
  destruct Ht as [ _ Ht _ ].
  specialize (Ht _ Hred); destruct Ht as [ t₂' [ Hrtc' Ht' ] ].
  apply IH in Ht'; [ | assumption ].
  destruct Ht' as [ v₂ Hrtc'' ]; exists v₂.
  eapply red_rtc_trans; eassumption.
Qed.

Theorem soundness (R : term_rel) :
  (R ↣ R & R) → R ⊆ ctx_approx.
Proof.
intros Hsim V t₁ t₂ Ht C.
apply (adequacy (combo R)).
+ apply combo_evolution; assumption.
+ apply precongruence, (combo_id R); auto.
Qed.