Require Import Utf8.
Require Import TermRelation Simulation Monotonicity.

Lemma progress_sum (R₁ R₂ Q S : term_rel) :
  (R₁ ↣ Q & S) → (R₂ ↣ Q & S) →
  (λ V t₁ t₂, R₁ V t₁ t₂ ∨ R₂ V t₁ t₂) ↣ Q & S.
Proof.
intros HR₁ HR₂; split.
+ intros V t₁ t₂ [ H | H ].
  - apply HR₁; assumption.
  - apply HR₂; assumption.
+ intros V t₁ t₂ [ H | H ].
  - apply HR₁; assumption.
  - apply HR₂; assumption.
Qed.

Lemma progress_sub123 (R₁ R₂ Q₁ Q₂ S₁ S₂ : term_rel) :
  R₂ ⊆ R₁ → Q₁ ⊆ Q₂ → S₁ ⊆ S₂ → R₁ ↣ Q₁ & S₁ → R₂ ↣ Q₂ & S₂.
Proof.
intros HR HQ HS HRQS; split.
+ eapply rel_sub_trans; [ | eapply passive_step_monotone; eassumption ].
  eapply rel_sub_trans; [ apply HR | ].
  apply HRQS.
+ eapply rel_sub_trans; [ | eapply active_step_monotone; eassumption ].
  eapply rel_sub_trans; [ apply HR | ].
  apply HRQS.
Qed.

Lemma progress_sub23 (R Q₁ Q₂ S₁ S₂ : term_rel) :
  Q₁ ⊆ Q₂ → S₁ ⊆ S₂ → R ↣ Q₁ & S₁ → R ↣ Q₂ & S₂.
Proof.
apply progress_sub123; auto.
Qed.

Lemma evolution_sum (f₁ f₂ g h : term_rel → term_rel) :
  f₁ ↝ g & h → f₂ ↝ g & h → (f₁ ∪ f₂) ↝ g & h.
Proof.
intros Hf₁ Hf₂ R S HRS; unfold trf_sum.
apply progress_sum.
+ apply Hf₁; assumption.
+ apply Hf₂; assumption.
Qed.

Lemma str_evolution_sum (f₁ f₂ g h : term_rel → term_rel) :
  f₁ !↝ g & h → f₂ !↝ g & h → (f₁ ∪ f₂) !↝ g & h.
Proof.
intros Hf₁ Hf₂ R Q S HRQS; unfold trf_sum.
apply progress_sum.
+ apply Hf₁; assumption.
+ apply Hf₂; assumption.
Qed.

Lemma evolution_comp_l (f₁ f₂ g₁ g₂ h₁ h₂ : term_rel → term_rel) :
  f₁ !↝ g₁ & h₁ → f₂ ↝ g₂ & h₂ → (f₁ ◦ f₂) ↝ (g₁ ◦ g₂) & (h₁ ◦ h₂).
Proof.
intros Hev₁ Hev₂ R S HRQS.
apply Hev₁, Hev₂; assumption.
Qed.

Lemma evolution_comp_r (f₁ f₂ g h₁ h₂ : term_rel → term_rel) :
  f₁ ↝ g & h₁ → f₂ !↝ f₂ & h₂ → (f₁ ◦ f₂) ↝ (g ◦ f₂) & (h₁ ◦ h₂).
Proof.
intros Hev₁ Hev₂ R S HRQS.
apply Hev₁, Hev₂; assumption.
Qed.

Lemma evolution_comp (f₁ f₂ g h₁ h₂ : term_rel → term_rel) :
  f₁ ↝ g & h₁ → f₂ ↝ f₂ & h₂ → (f₁ ◦ f₂) ↝ (g ◦ f₂) & (h₁ ◦ h₂).
Proof.
intros Hev₁ Hev₂ R S HRQS.
apply Hev₁, Hev₂; assumption.
Qed.

Lemma str_evolution_comp (f₁ f₂ g₁ g₂ h₁ h₂ : term_rel → term_rel) :
  f₁ !↝ g₁ & h₁ → f₂ !↝ g₂ & h₂ → (f₁ ◦ f₂) !↝ (g₁ ◦ g₂) & (h₁ ◦ h₂).
Proof.
intros Hev₁ Hev₂ R Q S HRQS.
apply Hev₁, Hev₂; assumption.
Qed.

Lemma evolution_limit (f h : term_rel → term_rel) :
  (∀ n, (f ^ n) ↝ (f ^ n) & h) → (f ^ω) ↝ (f ^ω) & h.
Proof.
intros Hn; intros R S HRS; split.
+ intros V t₁ t₂ Ht; destruct Ht as [ n Ht ].
  destruct (Hn n _ _ HRS).
  eapply passive_step_monotone; [ | apply pt_passive, Ht ].
  intros; exists n; assumption.
+ intros V t₁ t₂ Ht; destruct Ht as [ n Ht ].
  destruct (Hn n _ _ HRS); auto.
Qed.

Lemma str_evolution_limit (f g h : term_rel → term_rel) :
  (∀ n, (f ^ n) !↝ g & h) → (f ^ω) !↝ g & h.
Proof.
intros Hn; intros R Q S HRQS; split.
+ intros V t₁ t₂ Ht; destruct Ht as [ n Ht ].
  destruct (Hn n _ _ _ HRQS); auto.
+ intros V t₁ t₂ Ht; destruct Ht as [ n Ht ].
  destruct (Hn n _ _ _ HRQS); auto.
Qed.

Lemma evolution_sub123 (f₁ f₂ g₁ g₂ h₁ h₂ : term_rel → term_rel) :
  (∀ R, f₂ R ⊆ f₁ R) → (∀ R, g₁ R ⊆ g₂ R) → (∀ R, h₁ R ⊆ h₂ R) →
  f₁ ↝ g₁ & h₁ → f₂ ↝ g₂ & h₂.
Proof.
intros Hf Hg Hh Hev R S HRS; apply Hev in HRS.
eapply progress_sub123; [ | | | eassumption ]; auto.
Qed.

Lemma evolution_sub23 (f g₁ g₂ h₁ h₂ : term_rel → term_rel) :
  (∀ R, g₁ R ⊆ g₂ R) → (∀ R, h₁ R ⊆ h₂ R) →
  f ↝ g₁ & h₁ → f ↝ g₂ & h₂.
Proof.
apply evolution_sub123; auto.
Qed.

Lemma str_evolution_sub23 (f g₁ g₂ h₁ h₂ : term_rel → term_rel) :
  (∀ R, g₁ R ⊆ g₂ R) → (∀ R, h₁ R ⊆ h₂ R) →
  f !↝ g₁ & h₁ → f !↝ g₂ & h₂.
Proof.
intros Hg Hh Hev R S Q HRQS; apply Hev in HRQS.
eapply progress_sub23; [ | | eassumption ]; auto.
Qed.

Lemma strong_is_regular (f g h : term_rel → term_rel) :
  f !↝ g & h → f ↝ g & h.
Proof.
intros Hfgh R S; apply Hfgh.
Qed.