Require Import Utf8.
Require Import TermRelation Simulation UpToTechniques.
Require Import Monotonicity Finiteness.
Require Import ProgressProperties.

Require UpToVar UpToLam UpToApp UpToSubst UpToEctx UpToMap UpToRed.

Definition combo1 : term_rel → term_rel :=
  (((var ∪ var2) ∪ (lam ∪ app)) ∪ ((subst ∪ ectxr) ∪ (map ∪ redr)))
  ∪ id.

Definition combo_str1 : term_rel → term_rel :=
  ((var ∪ var2) ∪ (lam ∪ map)) ∪ (redr ∪ id).

Definition combo : term_rel → term_rel := combo1 ^ω.

Definition combo_str : term_rel → term_rel := combo_str1 ^ω.

Definition combo1' : term_rel → term_rel :=
  (combo_str ◦ combo1 ◦ combo_str).

Definition combo' : term_rel → term_rel := combo1' ^ω.

Lemma combo1_monotone : monotone combo1.
Proof.
unfold combo1; repeat apply sum_monotone.
+ apply var_monotone.
+ apply var2_monotone.
+ apply lam_monotone.
+ apply app_monotone.
+ apply subst_monotone.
+ apply ectxr_monotone.
+ apply map_monotone.
+ apply redr_monotone.
+ unfold monotone; auto.
Qed.

Lemma combo_str1_monotone : monotone combo_str1.
Proof.
unfold combo_str1; repeat apply sum_monotone.
+ apply var_monotone.
+ apply var2_monotone.
+ apply lam_monotone.
+ apply map_monotone.
+ apply redr_monotone.
+ unfold monotone; auto.
Qed.

Lemma combo_monotone : monotone combo.
Proof.
apply omega_monotone, combo1_monotone.
Qed.

Lemma combo_str_monotone : monotone combo_str.
Proof.
apply omega_monotone, combo_str1_monotone.
Qed.

Lemma combo1'_monotone : monotone combo1'.
Proof.
unfold combo1'; repeat apply comp_monotone.
+ apply combo_str_monotone.
+ apply combo1_monotone.
+ apply combo_str_monotone.
Qed.

Lemma combo1_finite : finite combo1.
Proof.
unfold combo1; repeat apply sum_finite.
+ apply var_finite.
+ apply var2_finite.
+ apply lam_finite.
+ apply app_finite.
+ apply subst_finite.
+ apply ectxr_finite.
+ apply map_finite.
+ apply redr_finite.
+ unfold finite; auto.
Qed.

Lemma combo_str1_finite : finite combo_str1.
Proof.
unfold combo_str1; repeat apply sum_finite.
+ apply var_finite.
+ apply var2_finite.
+ apply lam_finite.
+ apply map_finite.
+ apply redr_finite.
+ unfold finite; auto.
Qed.

Lemma combo_id (R S : term_rel) :
  R ⊆ S → R ⊆ combo S.
Proof.
intro HRS; eapply rel_sub_trans; [ eassumption | apply omega_id ].
Qed.

Lemma combo_str_id (R S : term_rel) :
  R ⊆ S → R ⊆ combo_str S.
Proof.
intro HRS; eapply rel_sub_trans; [ eassumption | apply omega_id ].
Qed.

Lemma combo_take (R S : term_rel) :
  R ⊆ combo1 (combo S) → R ⊆ combo S.
Proof.
intro HR; eapply rel_sub_trans; [ apply HR | ].
apply combo1_finite; auto.
Qed.

Lemma combo_str_take (R S : term_rel) :
  R ⊆ combo_str1 (combo_str S) → R ⊆ combo_str S.
Proof.
intro HR; eapply rel_sub_trans; [ apply HR | ].
apply combo_str1_finite; auto.
Qed.

Lemma combo1_var (R S : term_rel) :
  R ⊆ S → var R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_l, sum_sub_l, sum_sub_l;
  apply var_monotone; assumption.
Qed.

Lemma combo1_var2 (R S : term_rel) :
  R ⊆ S → var2 R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_l, sum_sub_l, sum_sub_r;
  apply var2_monotone; assumption.
Qed.

Lemma combo1_lam (R S : term_rel) :
  R ⊆ S → lam R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_l, sum_sub_r, sum_sub_l;
  apply lam_monotone; assumption.
Qed.

Lemma combo1_app (R S : term_rel) :
  R ⊆ S → app R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_l, sum_sub_r, sum_sub_r;
  apply app_monotone; assumption.
Qed.

Lemma combo1_subst (R S : term_rel) :
  R ⊆ S → subst R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_r, sum_sub_l, sum_sub_l;
  apply subst_monotone; assumption.
Qed.

Lemma combo1_ectxr (R S : term_rel) :
  R ⊆ S → ectxr R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_r, sum_sub_l, sum_sub_r;
  apply ectxr_monotone; assumption.
Qed.

Lemma combo1_map (R S : term_rel) :
  R ⊆ S → map R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_r, sum_sub_r, sum_sub_l;
  apply map_monotone; assumption.
Qed.

Lemma combo1_redr (R S : term_rel) :
  R ⊆ S → redr R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_l, sum_sub_r, sum_sub_r, sum_sub_r;
  apply redr_monotone; assumption.
Qed.

Lemma combo1_id (R S : term_rel) :
  R ⊆ S → R ⊆ combo1 S.
Proof.
intro Hsub; unfold combo1.
apply sum_sub_r; assumption.
Qed.

Lemma combo_str1_var (R S : term_rel) :
  R ⊆ S → var R ⊆ combo_str1 S.
Proof.
intro Hsub; unfold combo_str1.
apply sum_sub_l, sum_sub_l, sum_sub_l; apply var_monotone; assumption.
Qed.

Lemma combo_str1_var2 (R S : term_rel) :
  R ⊆ S → var2 R ⊆ combo_str1 S.
Proof.
intro Hsub; unfold combo_str1.
apply sum_sub_l, sum_sub_l, sum_sub_r; apply var2_monotone; assumption.
Qed.

Lemma combo_str1_lam (R S : term_rel) :
  R ⊆ S → lam R ⊆ combo_str1 S.
Proof.
intro Hsub; unfold combo_str1.
apply sum_sub_l, sum_sub_r, sum_sub_l; apply lam_monotone; assumption.
Qed.

Lemma combo_str1_map (R S : term_rel) :
  R ⊆ S → map R ⊆ combo_str1 S.
Proof.
intro Hsub; unfold combo_str1.
apply sum_sub_l, sum_sub_r, sum_sub_r; apply map_monotone; assumption.
Qed.

Lemma combo_str1_redr (R S : term_rel) :
  R ⊆ S → redr R ⊆ combo_str1 S.
Proof.
intro Hsub; unfold combo_str1.
apply sum_sub_r, sum_sub_l; apply redr_monotone; assumption.
Qed.

Lemma combo_var (R S : term_rel) :
  R ⊆ (combo S) → var R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_var; assumption.
Qed.

Lemma combo_var2 (R S : term_rel) :
  R ⊆ (combo S) → var2 R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_var2; assumption.
Qed.

Lemma combo_lam (R S : term_rel) :
  R ⊆ (combo S) → lam R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_lam; assumption.
Qed.

Lemma combo_app (R S : term_rel) :
  R ⊆ (combo S) → app R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_app; assumption.
Qed.

Lemma combo_subst (R S : term_rel) :
  R ⊆ (combo S) → subst R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_subst; assumption.
Qed.

Lemma combo_ectxr (R S : term_rel) :
  R ⊆ (combo S) → ectxr R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_ectxr; assumption.
Qed.

Lemma combo_map (R S : term_rel) :
  R ⊆ (combo S) → map R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_map; assumption.
Qed.

Lemma combo_redr (R S : term_rel) :
  R ⊆ (combo S) → redr R ⊆ (combo S).
Proof.
intro Hsub; apply combo_take, combo1_redr; assumption.
Qed.

Lemma combo_subst_act (R S : term_rel) :
  R ⊆ (combo S) → UpToSubst.subst_act R ⊆ (combo S).
Proof.
intro Hsub; unfold UpToSubst.subst_act.
apply sum_subset; apply sum_subset.
+ apply combo_subst; assumption.
+ apply combo_subst, combo_map, sum_subset.
  - assumption.
  - apply combo_subst, combo_map; assumption.
+ apply combo_ectxr, combo_subst, sum_subset.
  - apply combo_map; assumption.
  - apply combo_subst, combo_map; assumption.
+ apply combo_ectxr, sum_subset.
  - apply combo_map, combo_subst, combo_map; assumption.
  - apply combo_subst, combo_map, sum_subset.
    * assumption.
    * apply combo_subst, combo_map; assumption.
Qed.

Lemma combo_ectxr_act (R S : term_rel) :
  R ⊆ (combo S) → UpToEctx.ectxr_act R ⊆ (combo S).
Proof.
intro Hsub; unfold UpToEctx.ectxr_act.
apply sum_subset; apply sum_subset.
+ apply combo_ectxr; assumption.
+ apply combo_ectxr, combo_map; assumption.
+ apply combo_subst_act; assumption.
+ assumption.
Qed.

Lemma combo_app_act (R S : term_rel) :
  R ⊆ (combo S) → UpToApp.app_act R ⊆ (combo S).
Proof.
intro Hsub; unfold UpToApp.app_act.
apply sum_subset; apply sum_subset.
+ apply combo_app; assumption.
+ apply combo_app, combo_map; assumption.
+ apply combo_subst; assumption.
+ apply combo_ectxr_act; assumption.
Qed.

Lemma combo_str_var (R S : term_rel) :
  R ⊆ (combo_str S) → var R ⊆ (combo_str S).
Proof.
intro Hsub; apply combo_str_take, combo_str1_var; assumption.
Qed.

Lemma combo_str_var2 (R S : term_rel) :
  R ⊆ (combo_str S) → var2 R ⊆ (combo_str S).
Proof.
intro Hsub; apply combo_str_take, combo_str1_var2; assumption.
Qed.

Lemma combo_str_lam (R S : term_rel) :
  R ⊆ (combo_str S) → lam R ⊆ (combo_str S).
Proof.
intro Hsub; apply combo_str_take, combo_str1_lam; assumption.
Qed.

Lemma combo_str_map (R S : term_rel) :
  R ⊆ (combo_str S) → map R ⊆ (combo_str S).
Proof.
intro Hsub; apply combo_str_take, combo_str1_map; assumption.
Qed.

Lemma combo_str_redr (R S : term_rel) :
  R ⊆ (combo_str S) → redr R ⊆ (combo_str S).
Proof.
intro Hsub; apply combo_str_take, combo_str1_redr; assumption.
Qed.

(* ========================================================================= *)

Lemma combo_combo_in_combo (R : term_rel) :
  (combo ◦ combo) R ⊆ combo R.
Proof.
apply omega_comp_omega.
+ apply combo1_monotone.
+ apply combo1_finite.
Qed.

Lemma combo_str_combo_str_in_combo_str (R : term_rel) :
  (combo_str ◦ combo_str) R ⊆ combo_str R.
Proof.
apply omega_comp_omega.
+ apply combo_str1_monotone.
+ apply combo_str1_finite.
Qed.

Lemma combo_combo_str (R S : term_rel) :
  R ⊆ combo S → combo_str R ⊆ combo S.
Proof.
intro Hsub; eapply rel_sub_trans; [ | apply combo_combo_in_combo ].
eapply rel_sub_trans; [ apply combo_str_monotone; eassumption | ].
apply omega_monotone_f; [ apply combo1_monotone | ]; clear R S Hsub; intro R.
unfold combo_str1; repeat apply sum_subset.
+ apply combo1_var; auto.
+ apply combo1_var2; auto.
+ apply combo1_lam; auto.
+ apply combo1_map; auto.
+ apply combo1_redr; auto.
+ apply combo1_id; auto.
Qed.

Lemma combo_in_combo' (R : term_rel) : combo R ⊆ combo' R.
Proof.
apply omega_monotone_f.
+ apply combo1'_monotone.
+ clear R; intro R; unfold combo1'.
  apply combo_str_id, combo1_monotone, combo_str_id; auto.
Qed.

Lemma combo'_in_combo (R : term_rel) : combo' R ⊆ combo R.
Proof.
apply omega_limit; intro n; induction n; simpl.
+ apply combo_id; auto.
+ apply sum_subset; [ assumption | ].
  unfold combo1'.
  apply combo_combo_str, combo_take, combo1_monotone, combo_combo_str.
  assumption.
Qed.

(* ========================================================================= *)

Lemma var_combo_evolution : var ↝ combo1' & combo.
Proof.
eapply evolution_sub23;
  [ | | apply strong_is_regular, UpToVar.var_evolution ]; intro R.
+ apply sum_subset.
  - apply combo_str_id, combo1_var, combo_str_id; auto.
  - apply combo_str_id, combo1_var2, combo_str_id; auto.
+ apply combo_var, combo_id; auto.
Qed.

Lemma var_combo_str_evolution : var !↝ combo_str & combo.
Proof.
eapply str_evolution_sub23; [ | | apply UpToVar.var_evolution ]; intro R.
+ apply sum_subset.
  - apply combo_str_var, combo_str_id; auto.
  - apply combo_str_var2, combo_str_id; auto.
+ apply combo_var, combo_id; auto.
Qed.

Lemma var2_combo_evolution : var2 ↝ combo1' & combo.
Proof.
eapply evolution_sub23;
  [ | | apply strong_is_regular, UpToVar.var2_evolution ]; intro R.
+ apply combo_str_id, combo1_var2, combo_str_id; auto.
+ apply sum_subset.
  - apply combo_var, combo_id; auto.
  - apply combo_var2, combo_id; auto.
Qed.

Lemma var2_combo_str_evolution : var2 !↝ combo_str & combo.
Proof.
eapply str_evolution_sub23; [ | | apply UpToVar.var2_evolution ]; intro R.
+ apply combo_str_var2, combo_str_id; auto.
+ apply sum_subset.
  - apply combo_var, combo_id; auto.
  - apply combo_var2, combo_id; auto.
Qed.

Lemma lam_combo_evolution : lam ↝ combo1' & combo.
Proof.
eapply evolution_sub23;
  [ | | apply strong_is_regular, UpToLam.lam_evolution ]; intro R.
+ apply sum_subset.
  - apply combo_str_id, combo1_lam, combo_str_id; auto.
  - apply combo_str_redr, combo_str_id, combo1_id, combo_str_id; auto.
+ apply combo_lam, combo_id; auto.
Qed.

Lemma lam_combo_str_evolution : lam !↝ combo_str & combo.
Proof.
eapply str_evolution_sub23; [ | | apply UpToLam.lam_evolution ]; intro R.
+ apply sum_subset.
  - apply combo_str_lam, combo_str_id; auto.
  - apply combo_str_redr, combo_str_id; auto.
+ apply combo_lam, combo_id; auto.
Qed.

Lemma app_combo_evolution : app ↝ combo1' & combo.
Proof.
eapply evolution_sub23; [ | | apply UpToApp.app_evolution ]; intro R.
+ apply combo_str_id, combo1_app, combo_str_id; auto.
+ apply combo_app_act, combo_id; auto.
Qed.

Lemma subst_combo_evolution : subst ↝ combo1' & combo.
Proof.
eapply evolution_sub23; [ | | apply UpToSubst.subst_evolution ]; intro R.
+ apply combo_str_id, combo1_subst, combo_str_map, combo_str_id; auto.
+ apply combo_subst_act, combo_id; auto.
Qed.

Lemma ectxr_combo_evolution : ectxr ↝ combo1' & combo.
Proof.
eapply evolution_sub23; [ | | apply UpToEctx.ectxr_evolution ]; intro R.
+ apply sum_subset.
  - apply combo_str_id, combo1_ectxr, combo_str_id; auto.
  - apply combo_str_id, combo1_subst, combo_str_map, combo_str_id; auto.
+ apply combo_ectxr_act, combo_id; auto.
Qed.

Lemma map_combo_evolution : map ↝ combo1' & combo.
Proof.
eapply evolution_sub23;
  [ | | apply strong_is_regular, UpToMap.map_evolution ]; intro R.
+ apply combo_str_map, combo_str_id, combo1_id, combo_str_id; auto.
+ apply combo_map, combo_id; auto.
Qed.

Lemma map_combo_str_evolution : map !↝ combo_str & combo.
Proof.
eapply str_evolution_sub23; [ | | apply UpToMap.map_evolution ]; intro R.
+ apply combo_str_map, combo_str_id; auto.
+ apply combo_map, combo_id; auto.
Qed.

Lemma redr_combo_evolution : redr ↝ combo1' & combo.
Proof.
eapply evolution_sub23;
  [ | | apply strong_is_regular, UpToRed.redr_evolution ]; intro R.
+ apply sum_subset.
  - apply combo_str_redr, combo_str_id, combo1_id, combo_str_id; auto.
  - apply combo_str_id, combo1_id, combo_str_id; auto.
+ apply sum_subset.
  - apply combo_redr, combo_id; auto.
  - apply combo_id; auto.
Qed.

Lemma redr_combo_str_evolution : redr !↝ combo_str & combo.
Proof.
eapply str_evolution_sub23; [ | | apply UpToRed.redr_evolution ]; intro R.
+ apply sum_subset.
  - apply combo_str_redr, combo_str_id; auto.
  - apply combo_str_id; auto.
+ apply sum_subset.
  - apply combo_redr, combo_id; auto.
  - apply combo_id; auto.
Qed.

Lemma id_combo_evolution : id ↝ combo1' & combo.
Proof.
eapply evolution_sub23;
  [ | | apply strong_is_regular, id_evolution ]; intro R.
+ apply combo_str_id, combo1_id, combo_str_id; auto.
+ apply combo_id; auto.
Qed.

Lemma id_combo_str_evolution : id !↝ combo_str & combo.
Proof.
eapply str_evolution_sub23; [ | | apply id_evolution ]; intro R.
+ apply combo_str_id; auto.
+ apply combo_id; auto.
Qed.

Lemma combo1_evolution : combo1 ↝ combo1' & combo.
Proof.
unfold combo1 at 1; repeat apply evolution_sum.
+ apply var_combo_evolution.
+ apply var2_combo_evolution.
+ apply lam_combo_evolution.
+ apply app_combo_evolution.
+ apply subst_combo_evolution.
+ apply ectxr_combo_evolution.
+ apply map_combo_evolution.
+ apply redr_combo_evolution.
+ apply id_combo_evolution.
Qed.

Lemma combo_str1_evolution : combo_str1 !↝ combo_str & combo.
Proof.
unfold combo_str1; repeat apply str_evolution_sum.
+ apply var_combo_str_evolution.
+ apply var2_combo_str_evolution.
+ apply lam_combo_str_evolution.
+ apply map_combo_str_evolution.
+ apply redr_combo_str_evolution.
+ apply id_combo_str_evolution.
Qed.

Lemma combo_str1_iter_evolution (n : nat) :
  combo_str1 ^ n !↝ combo_str & combo.
Proof.
induction n; simpl; [ apply id_combo_str_evolution | ].
apply str_evolution_sum; [ assumption | ].
apply str_evolution_sub23 with
  (g₁ := combo_str ◦ combo_str) (h₁ := combo ◦ combo).
+ intro R; apply combo_str_combo_str_in_combo_str.
+ intro R; apply combo_combo_in_combo.
+ apply str_evolution_comp.
  - apply combo_str1_evolution.
  - assumption.
Qed.

Lemma combo_str_evolution : combo_str !↝ combo_str & combo.
Proof.
apply str_evolution_limit; exact (combo_str1_iter_evolution).
Qed.

Lemma combo1'_evolution : combo1' ↝ combo1' & combo.
Proof.
assert (H := evolution_comp_r _ _ _ _ _
  (evolution_comp_l _ _ _ _ _ _ combo_str_evolution combo1_evolution)
  combo_str_evolution).
eapply evolution_sub23; [ | | eassumption ]; intro R.
+ unfold combo1'; unfold trf_comp.
  eapply rel_sub_trans; [ | apply combo_str_combo_str_in_combo_str ].
  apply combo_str_monotone, combo_str_monotone, combo1_monotone.
  apply combo_str_combo_str_in_combo_str.
+ eapply rel_sub_trans; [ | apply combo_combo_in_combo ].
  apply combo_monotone, combo_combo_in_combo.
Qed.

Lemma combo1'_iter_evolution (n : nat) :
  combo1' ^ n ↝ combo1' ^ n & combo.
Proof.
induction n; simpl.
{ eapply evolution_sub23;
    [ | | apply strong_is_regular, id_evolution ]; intro R.
+ auto.
+ apply combo_id; auto.
}
apply evolution_sum.
{ eapply evolution_sub23; [ | | eassumption ]; intro R.
+ unfold trf_sum; auto.
+ auto.
}
assert (H := evolution_comp _ _ _ _ _ combo1'_evolution IHn).
eapply evolution_sub23; [ | | exact H ]; intro R.
+ apply sum_sub_r; auto.
+ apply combo_combo_in_combo.
Qed.

Lemma combo'_evolution : combo' ↝ combo' & combo.
Proof.
apply evolution_limit; exact combo1'_iter_evolution.
Qed.

Lemma combo_evolution : combo ↝ combo & combo.
Proof.
eapply evolution_sub123; [ | | | apply combo'_evolution ]; intro R.
+ apply combo_in_combo'.
+ apply combo'_in_combo.
+ auto.
Qed.