open Lazy

let map = List.map
let id x = x

type _ typ =
  | Int : int typ
  | Bool : bool typ
  | String : string typ
  | List : 'a typ -> 'a list typ
  | Pair : 'a typ * 'b typ -> ('a * 'b) typ

type trav = { f : 'a . 'a typ -> ('a -> 'a) }

let imap { f }  =
  let aux : type a . a typ -> (a -> a) = function
    | Int -> id
    | Bool -> id
    | String -> id
    | List t -> map (f t)
    | Pair (at, bt) -> fun (x, y) -> (f at x, f bt y)
  in { f = aux }

let ( >> ) tr1 tr2 =
  let aux t x = tr2.f t (tr1.f t x)
  in { f = aux }

let lazy_trav ltr = { f = fun t -> (force ltr).f t }

let rec allover tr = tr >> imap (lazy_trav (lazy (allover tr)))

let bump =
  let aux : type a . a typ -> (a -> a) = function
    | Int -> ( + ) 1
    | _ -> id
  in { f = aux }
