type _ term =
  | Zero : int term
  | Succ : int term -> int term
  | Pred : int term -> int term
  | IsZero : int term -> bool term
  | If : bool term * 'a term * 'a term -> 'a term

let rec eval : type a . a term -> a = function
  | Zero -> 0
  | Succ expr -> eval expr + 1
  | Pred expr -> eval expr - 1
  | IsZero expr -> eval expr = 0
  | If (cexpr, texpr, fexpr) ->
    if eval cexpr then eval texpr
    else eval fexpr
