open Lazy

let fold_left = List.fold_left
let id x = x

type _ typ =
  | Int : int typ
  | Bool : bool typ
  | String : string typ
  | List : 'a typ -> 'a list typ
  | Pair : 'a typ * 'b typ -> ('a * 'b) typ

type 'b query = { q : 'a . 'a typ -> ('a -> 'b) }

let isum { q }  =
  let null _ = 0 in
  let aux : type a . a typ -> (a -> int) = function
    | Int -> null
    | Bool -> null
    | String -> null
    | List t -> fold_left (fun a x -> a + q t x) 0
    | Pair (at, bt) -> fun (x, y) -> q at x + q bt y
  in { q = aux }

let ( ++ ) qr1 qr2 =
  let aux t x = qr1.q t x + qr2.q t x
  in { q = aux }

let lazy_query lqr = { q = fun t -> (force lqr).q t }

let rec total qr =
  qr ++ isum (lazy_query (lazy (total qr)))

let sizeof =
  let one _ = 1 in
  let aux : type a . a typ -> (a -> int) = function
    | Int -> one
    | Bool -> one
    | String -> String.length
    | List _ -> List.length
    | Pair (_, _) -> one
  in { q = aux }
