let fold_left = List.fold_left

type _ typ =
  | Int : int typ
  | Bool : bool typ
  | String : string typ
  | List : 'a typ -> 'a list typ
  | Pair : 'a typ * 'b typ -> ('a * 'b) typ

let rec show : type a . a typ -> a -> string =
  fun t x -> match t with
  | Int -> string_of_int x
  | Bool -> string_of_bool x
  | String -> "'" ^ x ^ "'"
  | List t' ->
    let aux s y = s ^ show t' y ^ " " in
    fold_left aux "[ " x ^ "]"
  | Pair (ta, tb) ->
    "("  ^ show ta (fst x) ^ ", " ^ show tb (snd x) ^ ")"
