let id x = x

type (_, _) dir =
  | Lit : string -> ('a, 'a) dir
  | String : (string -> 'a, 'a) dir
  | Int : (int -> 'a, 'a) dir
  | Node : ('a, 'b) dir * ('b, 'c) dir -> ('a, 'c) dir

let ( ++ ) d1 d2 = Node (d1, d2)

let format d =
  let rec aux : type a b . (a, b) dir -> (string -> b) -> string -> a =
  fun d k r -> match d with
    | Lit s -> k (r ^ s)
    | String -> fun s -> k (r ^ s)
    | Int -> fun n -> k (r ^ string_of_int n)
    | Node (d1, d2) -> aux d1 (aux d2 k) r
  in aux d id ""
