let map = List.map
let id x = x

type dyn = Dyn : 'a typ * 'a -> dyn
and _ typ =
  | Int : int typ
  | Bool : bool typ
  | String : string typ
  | List : 'a typ -> 'a list typ
  | Pair : 'a typ * 'b typ -> ('a * 'b) typ
  | Dynamic : dyn typ

let rec tequal
  : type a b . a typ -> b typ -> (a -> b) option =
  fun t1 t2 -> match t1, t2 with
  | Int, Int -> Some id
  | Bool, Bool -> Some id
  | String, String -> Some id
  | List t1', List t2' -> (
    match tequal t1' t2' with
    | Some f -> Some (map f)
    | None -> None )
  | Pair (ta1, tb1), Pair (ta2, tb2) -> (
    match tequal ta1 ta2, tequal tb1 tb2 with
    | Some f, Some g -> Some (fun (x, y) -> (f x, g y))
    | _ -> None )
  | _ -> None

let cast : type a . a typ -> dyn -> a option =
  fun t2 (Dyn (t1, x)) -> match tequal t1 t2 with
  | Some f -> Some (f x)
  | None -> None
