import Graphics.Gnuplot.Simple

zwykly :: Double -> Double
zwykly x =x**8-8*x**7+28*x**6-56*x**5+70*x**4-56*x**3+28*x**2-8*x+1 

horner :: Double -> Double
horner x = x*(x*(x*(x*(x*(x*((x-8)*x+28)-56)+70)-56)+28)-8)+1

najmniej :: Double -> Double
najmniej x = a4*a4
    where
        a1 = x-1
        a2 = a1*a1
        a4 = a2*a2

probkuj :: (Double,Double) -> Int -> (Double -> Double) -> [(Double,Double)] 
probkuj (zakres_pocz,zakres_kon) ile_probek funkcja =
    map (\x -> (x,funkcja x)) [x| x<-[zakres_pocz,zakres_pocz+krok..zakres_kon]]
    where krok = (zakres_kon-zakres_pocz)/ (fromIntegral ile_probek)

zrob f = probkuj (0.98,1.02) 200 f
zroob i f = probkuj (0.98,1.02) i f

styl t = (defaultStyle {lineSpec = CustomStyle [LineTitle t]})

maain = do
    plotListsStyle [PNG "wykres.png",XRange (0.98,1.02)] [(styl "Zwykly",zrob zwykly), (styl "Horner",zrob horner),(styl "Najmniej", zrob najmniej)]
