module Rysowanie where
import Graphics.Gnuplot.Simple
import Kola

styl t = (defaultStyle {lineSpec = CustomStyle [LineTitle t]})

styl_kolo = styl "(sin(x), cos(x))"
styl_jawny = styl "y(x+h)=y(x)+hy'(x)"
styl_wsteczny = styl "y(x+h)=y(x)+hy'(x+h)"
styl_trapezy = styl "y(x+h)=y(x)+h/2*(y'(x)+y'(x+h))"

duzo = 2^10

atr x_podpis y_podpis nazwa_pliku podpis = [PNG nazwa_pliku, Title podpis ,YLabel y_podpis, XLabel x_podpis]

--      Atrybuty pliku   Czy rysować poprawne kolo  [(Styl, funkcja_generująca )]  ile_punktów ile_krokow 
wycinki :: [Attribute] -> Bool -> [(PlotStyle,Int -> [(Double,Double)])]-> (Int -> Int) -> Int -> IO ()
wycinki atr czy_rysowac_poprawne co ile_pkt ile_krokow = do
    plotPathsStyle atr lista
    where
        lista = if czy_rysowac_poprawne then (styl_kolo,take (ile_pkt duzo) $ poprawne_kolo duzo):reszta else reszta 
        reszta = map zrob co
        zrob (styl,funcja) = (styl , take (ile_pkt ile_krokow) $ funcja ile_krokow)

kola :: [Attribute] -> Bool -> [(PlotStyle, Int -> [(Double,Double)])] -> Int -> Int -> IO()
kola atr czy_rysowac_poprawne co ile_okr ile_krokow = 
    wycinki atr czy_rysowac_poprawne co (\x -> ile_okr*x+1) ile_krokow
