module Kola where

krok :: Int -> Double
krok kr = 2.0*pi/fromIntegral kr

-- |   WZÓR JAWNY  | 
poprawne_kolo :: Int -> [(Double,Double)]
poprawne_kolo kr = map wsp_kola [0.0,krok kr..]
    where 
    wsp_kola kat = (cos kat, sin kat)

jawna_metoda_eulera :: Int -> [(Double,Double)]
jawna_metoda_eulera kr = map (\(_,b,c) -> (b,c)) lis
    where
    euler_jawny :: Int -> (Double,Double,Double) -> (Double,Double,Double)
    euler_jawny kr (t,x,y) =
        (t+h,x+h*(-y),y+h*(x)) --poprzednie + pochodna w punkcie poprzednim
            where h = krok kr
    lis = iterate (euler_jawny kr) (0.0,1.0,0.0)

wsteczna_metoda_eulera_popr :: Int -> [(Double,Double)]
wsteczna_metoda_eulera_popr kr = map (\(_,b,c) -> (b,c)) lis
    where
    euler_wsteczny :: Int -> (Double,Double,Double) -> (Double,Double,Double)
    euler_wsteczny kr (t,x,y) =
        (t+h,(x-h*y)/(1+h^2),y+h*((x-h*y)/(1+h^2))) -- patrz wzór wyprowadzony na ćwiczeniach
            where h = krok kr
    lis :: [(Double,Double,Double)]
    lis = iterate (euler_wsteczny kr) (0.0,1.0,0.0)


wzor_trapezow :: Int -> [(Double,Double)]
wzor_trapezow kr = map (\(_,b,c) -> (b,c)) lis
    where
    trapez :: Int -> (Double,Double,Double) -> (Double,Double,Double)
    trapez kr (t,x,y) =
        (t+h, x_n1, y+(h*(x+x_n1))/2) -- wzór wyprowadzony na ćwiczeniach
        where
            x_n1=(x-h*(y-h*x/4))/(1+h^2/4)
            h=krok kr
    lis :: [(Double,Double,Double)]
    lis = iterate (trapez kr) (0.0, 1.0, 0.0)

