module Bledy where
import Graphics.Gnuplot.Simple
import Data.Maybe
import Kola
import Rysowanie

blad :: [(Double,Double)] -> [(Double,Double)] -> ([Double],[Double])
blad l1 l2 = unzip $ zipWith (\(x,y) (a,b) -> (a-x, b-y)) l1 l2
blad_wzgledny :: [(Double,Double)] -> [(Double,Double)] -> ([Double],[Double])
blad_wzgledny l1 l2 =
    (catMaybes lix, catMaybes liy)
    where
        (lix,liy) = unzip $ zipWith (\(x,y) (a,b) -> (pom a x,pom b y)) l1 l2
        pom a x = if (abs x < 0.001) then Nothing else Just (abs $ (a-x)/x)
blad_bezwzgledny :: [(Double,Double)] -> [(Double,Double)] -> ([Double],[Double])
blad_bezwzgledny l1 l2 = unzip $ zipWith (\(x,y) (a,b) -> (abs (a-x), abs (b-y))) l1 l2

rysuj_blad ::[Attribute] -> (Int -> [(Double,Double)]) -> Int -> Int -> IO ()
rysuj_blad atr metoda ile_okrazen ile_krokow = do
    plotListsStyle atr [(styl "blad y",zrob bladx),(styl "blad x",zrob blady)]
    where
        ile = ile_krokow*ile_okrazen+1
        lista :: [(Double,Double)]
        lista = take ile $ metoda ile_krokow
        lista2 = take ile $ poprawne_kolo ile_krokow
        bladx :: [Double]
        blady :: [Double]
        (bladx,blady) = blad lista lista2
        zrob :: [Double] -> [(Double,Double)]
        zrob = zip [0.0,1.0..]

rysuj_blad_bezwzgledny :: [Attribute] -> (Int -> [(Double,Double)]) -> Int -> Int -> IO ()
rysuj_blad_bezwzgledny atr metoda ile_okrazen ile_krokow = do
    plotListsStyle atr [(styl "blad y",zrob bladx),(styl "blad x",zrob blady)]
    where
        ile = ile_krokow*ile_okrazen+1
        lista :: [(Double,Double)]
        lista = take ile $ metoda ile_krokow
        lista2 = take ile $ poprawne_kolo ile_krokow
        bladx :: [Double]
        blady :: [Double]
        (bladx,blady) = blad_bezwzgledny lista2 lista
        zrob :: [Double] -> [(Double,Double)]
        zrob = zip [0.0,1.0..]

rysuj_blad_wzgledny :: [Attribute] -> (Int -> [(Double,Double)]) -> Int -> Int -> IO ()
rysuj_blad_wzgledny atr metoda ile_okrazen ile_krokow = do
    plotListsStyle atr [(styl "blad y",zrob bladx),(styl "blad x",zrob blady)]
    where
        ile = ile_krokow*ile_okrazen+1
        lista :: [(Double,Double)]
        lista = take ile $ metoda ile_krokow
        lista2 = take ile $ poprawne_kolo ile_krokow
        bladx :: [Double]
        blady :: [Double]
        (bladx,blady) = blad_wzgledny lista2 lista
        zrob :: [Double] -> [(Double,Double)]
        zrob = zip [0.0,1.0..]

