module BledneKola where

krok :: Int -> Double
krok kr = 2.0*pi/fromIntegral kr

-- |   BŁĘDNE METODY  |
{- Pierwsza implementacja - z jawnie podaną pochodną. -}
xprim x = -(sin x)
yprim x = cos x

jawna_metoda_eulera :: Int -> [(Double,Double)]
jawna_metoda_eulera kr = map (\(_,b,c) -> (b,c)) lis
    where
    euler_jawny :: Int -> (Double,Double,Double) -> (Double,Double,Double)
    euler_jawny kr (t,x,y) =
        (t+h,x+h*(xprim t),y+h*(yprim t)) --poprzednie + pochodna w punkcie poprzednim
            where h = krok kr
    lis = iterate (euler_jawny kr) (0.0,1.0,0.0)

wsteczna_metoda_eulera :: Int -> [(Double,Double)]
wsteczna_metoda_eulera kr = map (\(_,b,c) -> (b,c)) lis
    where
    euler_wsteczny :: Int -> (Double,Double,Double) -> (Double,Double,Double)
    euler_wsteczny kr (t,x,y) =
        (t+h,x+h*(xprim (t+h)),y+h*(yprim (t+h))) --poprzednie + pochodna w punkcie obecnym
            where h = krok kr
    lis :: [(Double,Double,Double)]
    lis = iterate (euler_wsteczny kr) (0.0,1.0,0.0)

wzor_trapezow :: Int -> [(Double,Double)]
wzor_trapezow kr = map (\(_,b,c) -> (b,c)) lis
    where
    trapez :: Int -> (Double,Double,Double) -> (Double,Double,Double)
    trapez kr (t,x,y) =
        (t+h,x+h*(xprim (t+h)+xprim(t))/2,y+h*(yprim (t+h)+yprim(t))/2)
        --poprzedmie + 1/2 * pochodna w punkcie poprzednim + 1/2 * pochodna w punkcie obecnym
        where
            h=krok kr
    lis :: [(Double,Double,Double)]
    lis = iterate (trapez kr) (0.0, 1.0, 0.0)

