import numpy as np
import matplotlib.pyplot as plt

def expanded(x):
    return 1.0 - 8.0*x + 28.0*x*x - 56.0*x*x*x + 70.0 * x*x*x*x - 56.0*x*x*x*x*x + 28.0*x*x*x*x*x*x - 8.0*x*x*x*x*x*x*x + x*x*x*x*x*x*x*x

def horner(x):
    return 1.0 + x*(-8.0 + x*(28.0 + x*(-56.0 + x*(70.0 + x*(-56.0 + x*(28.0 + (-8.0 + x)*x))))))
    
def minOps(x):
    a = x - 1.0
    b = a * a
    c = b * b
    return c * c

x1 = np.array([])
for i in range(0, 1000): 
    x1 = np.append(x1, 0.98 + (1.02 - 0.98) * i / 1000.0)

y1 = expanded(x1)
y2 = horner(x1)
y3 = minOps(x1)

fig = plt.gcf()
fig.canvas.set_window_title('Wykresy wartosci wielomianu')

plt.subplots_adjust(0.04, 0.04, 0.96, 0.96)
plt.plot(x1, y1 ,'r', label = "Postac potegowa")
plt.plot(x1, y2, 'b', label = "Schemat Hornera")
plt.plot(x1, y3, 'g', linewidth=3, label = "Minimum operacji")
plt.title('Porownanie metod obliczania wartosci wielomianu')
plt.legend()
plt.grid(True)
plt.show()
