#include <allegro.h>
#include <algorithm>
#include <cstdio>
#include <cmath>
using namespace std;

#define fi first
#define se second

const double l0 = 100;
const double g = 9.81;
const double h = 0.001;

const int X0=300, Y0=100;

struct pd
{
	double fi, se;
	pd(double X=0, double Y=0) { fi = X; se = Y; }
	pd operator*(double x)
	{
		return pd(fi*x,se*x);
	}
	pd operator+(pd x)
	{
		return pd(fi+x.fi, se+x.se);
	}
};

int w;
double ex,ey;
double kx1,ky1;
double q0,q1;

pd f(pd y)
{
	pd res;
	res.fi = g*sin(y.se);
	double DX = kx1-ex, DY = ky1-ey;
	double D = hypot(DX,DY);
	res.fi += q0*q1 / D / D * sin(y.se-atan(DX/DY));
	res.fi /= l0;
	res.se = y.fi;
	return res;
}

int main()
{


	pd y(0, -M_PI/2);
	ex = -l0;

	printf("Podaj ladunek ciezarka na sznurku: ");
	//q0 = 100;
	scanf("%lf", &q0);


	printf("Podaj ladunek umieszczony na ziemi: ");
	scanf("%lf", &q1);
	// q1 = -100;
	printf("Podaj odleglosc miedzy ziemia a najnizszym punktem wahadla: ");
	scanf("%lf", &ky1);
	ky1 += l0;
	printf("Podaj wspolrzedna x ladunku: ");
	scanf("%lf", &kx1);
	//kx1 = -100;
	//ky1 = l0+1;

	printf("Wybierze metode (0-RK4, 1-Euler): ");
	int method;
	scanf("%d", &method);

 	allegro_init();

	install_keyboard();
	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
	clear_to_color(screen, makecol(100, 100, 100));

	BITMAP *bufor;
	bufor = create_bitmap(640, 480);
	while(!key[KEY_ESC])
	{

		clear_to_color(bufor, makecol(100,100,100));

		circlefill(bufor, ex+X0, ey+Y0, 10, makecol(200, 200, 200));
		circlefill(bufor, kx1+X0, ky1+Y0, 5, makecol(200, 200, 200));
		line(bufor, X0, Y0, ex+X0, ey+Y0, makecol(200,200,200));
		double l = hypot(ex,ey);

		pd k1, k2, k3, k4, dy;

		if(method == 0)
		{

			k1 = f(y)*h;
			k2 = f(y+k1*0.5)*h;
			k3 = f(y+k2*0.5)*h;
			k4 = f(y+k3)*h;

			dy = (k1+k2*2.0+k3*2.0+k4)*(1.0/6.0);
		}
		else
		{

			dy = f(y)*h;
		}


		y=y+dy;

		ex += dy.se * l0 * cos(y.se);
		ey += dy.se * l0 * sin(y.se);
		textprintf_ex(bufor, font, 20, 20, makecol(200,200,200), -1, "X=%.3lf, Y=%.3lf, V = %.3lf, a = %.3lf, l = %.3lf", ex, ey, dy.se*1000, dy.fi*1000, l);


		blit(bufor, screen, 0, 0, 0, 0, 640, 480);


	}

	allegro_exit();
	return 0;
}
END_OF_MAIN();
