# -*- coding: utf-8 -*-
from pylab import *

#----------------tutaj mozna wpisac rownanie, ktorego pole kierunkow ma byc znalezione
def funkcja(x, y):
    try:
 	return (x*x * y + y*y) / (4*x + 2*y) # modyfikowac te linijke
    except ZeroDivisionError:
        return float(NaN)

#----------------tutaj mozna zmodyfikowac parametry wykresu
xmax   = 3    # maksymalna wartosc na osi x
xmin   = -3   # minimalna wartosc na osi x
ymax   = 3    # maksymalna wartosc na osi y
ymin   = -3   # minimalna wartosc na osi y
xstep  = 0.1    # krok na osi x
ystep  = 0.1    # krok na osi y
length = 0.018   # dlugosc kreski - wartosc pomiędzy zerem a połową wartości xstep lub ystep

#----------------pozostaly kod

iksy = np.array([])
for i in range(0, abs(int((xmax - xmin) / xstep)) + 1): 
    iksy = np.append(iksy, xmin + i * xstep)

igreki = np.array([])
for i in range(0, abs(int((ymax - ymin) / ystep)) + 1): 
    igreki = np.append(igreki, ymin + i * ystep)

values = [[0 for col in igreki] for row in iksy]

for a in range(len(values)):
    for b in range(len(values[a])):
        values[a][b] = math.atan(funkcja(iksy[a], igreki[b]))
        
for a in range(len(values)):
  for b in range(len(values[a])):
        plt.plot([iksy[a] + length * math.cos(values[a][b]) , iksy[a] + length * math.cos(values[a][b] + math.pi)] ,
                 [igreki[b] + length * math.sin(values[a][b]), igreki[b] + length * math.sin(values[a][b] + math.pi)], 'k-')

cgf = plt.gcf()
cgf.canvas.set_window_title('Pole kierunkow')   
title('Pole kierunkow')                 
subplots_adjust(0.06, 0.04, 0.96, 0.96)
gray = '#5f5f5f'                                      
axhline(lw=2, c=gray)                                  
axvline(lw=2, c=gray)  
ylim([ymin, ymax])
xlim([xmin, xmax])
xlabel(r'$t$')
ylabel(r'$y$')
show()