/*
 * Decompiled with CFR 0.152.
 */
package math.utils;

import math.matrices.Vector;

public class Sequences {
    private Sequences() {
    }

    public static Vector arithmetic(int length, double from, double step) {
        Vector vec = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            vec.set(row, from + (double)(row - 1) * step);
        }
        return vec;
    }

    public static double sumOfArithmetic(int length, double from, double step) {
        return (from + (double)(length - 1) * step / 2.0) * (double)length;
    }

    public static Vector geometric(int length, double from, double q) {
        Vector vec = new Vector(length);
        double qn = from;
        for (int row = 1; row <= length; ++row) {
            vec.set(row, qn);
            qn *= q;
        }
        return vec;
    }

    public static double sumOfGeometric(int length, double from, double q) {
        return from * (1.0 - Math.pow(q, length)) / (1.0 - q);
    }

    public static Vector constant(int length, double c) {
        Vector vec = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            vec.set(row, c);
        }
        return vec;
    }

    public static double sumOfConstant(int length, int c) {
        return c * length;
    }

    public static Vector squares(int length) {
        Vector v = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            v.set(row, row * row);
        }
        return v;
    }

    public static double sumOfSquares(int n) {
        return (double)n * (double)(n + 1) * (double)(2 * n + 1) / 6.0;
    }

    public static Vector intersperse(int length) {
        Vector v = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            v.set(row, row % 2 == 0 ? -1 : 1);
        }
        return v;
    }

    public static double sumOfInterperse(int length) {
        return length % 2 == 0 ? 0.0 : 1.0;
    }

    public static Vector sineOfNatural(int length) {
        Vector v = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            v.set(row, Math.sin(row));
        }
        return v;
    }

    public static Vector cosineOfNatural(int length) {
        Vector v = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            v.set(row, Math.cos(row));
        }
        return v;
    }

    public static Vector tangentOfNatural(int length) {
        Vector v = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            v.set(row, Math.tan(row));
        }
        return v;
    }

    public static Vector cotangentOfNatural(int length) {
        Vector v = new Vector(length);
        for (int row = 1; row <= length; ++row) {
            v.set(row, 1.0 / Math.tan(row));
        }
        return v;
    }
}

