/*
 * Decompiled with CFR 0.152.
 */
package math.matrices;

import java.util.Iterator;
import java.util.List;
import math.matrices.DimensionException;
import math.matrices.Matrix;

public class Vector
extends Matrix
implements Iterable<Double> {
    public Vector(int rows) {
        super(rows, 1);
        this.set(1, 0.0);
    }

    public Vector(double[] vals) {
        super(vals);
    }

    public Vector(Vector original) {
        super(original);
    }

    public Vector(List<Double> vals) {
        super(vals.size(), 1);
        for (int row = 1; row <= vals.size(); ++row) {
            this.set(row, vals.get(row - 1));
        }
    }

    public final int getSize() {
        return this.getRows();
    }

    public final double get(int row) {
        return this.get(row, 1);
    }

    public final void set(int row, double val) {
        this.set(row, 1, val);
    }

    public Vector add(Vector other) throws DimensionException {
        if (this.getRows() != other.getRows()) {
            throw new DimensionException("Cannot add vector of diffrent lengths");
        }
        Vector res = new Vector(this.getRows());
        for (int row = 1; row <= this.getRows(); ++row) {
            res.set(row, this.get(row) + other.get(row));
        }
        return res;
    }

    @Override
    public Vector times(double t) {
        Vector res = new Vector(this.getRows());
        for (int row = 1; row <= this.getRows(); ++row) {
            res.set(row, this.get(row) * t);
        }
        return res;
    }

    public VecIterator iterator() {
        return new VecIterator();
    }

    public Vector subvector(int firstRow, int lastRow) {
        this.ensureSubvectorParamsOK(firstRow, lastRow);
        Vector res = new Vector(lastRow - firstRow + 1);
        for (int i = 1; i <= res.getSize(); ++i) {
            res.set(i, this.get(firstRow + i - 1));
        }
        return res;
    }

    private void ensureSubvectorParamsOK(int firstRow, int lastRow) {
        this.ensureIndicesOK(firstRow, 1);
        this.ensureIndicesOK(lastRow, 1);
        if (firstRow > lastRow) {
            throw new IllegalArgumentException("First row can not be greater than last row, firstRow = " + firstRow + ", lastRow = " + lastRow);
        }
    }

    public class VecIterator
    implements Iterator<Double> {
        int row = 0;

        @Override
        public boolean hasNext() {
            return this.row < Vector.this.getSize();
        }

        @Override
        public Double next() {
            return Vector.this.get(++this.row);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove does not have sense for constant size vectors.");
        }
    }
}

