/*
 * Decompiled with CFR 0.152.
 */
package math.approx;

import java.util.Arrays;
import math.approx.NoSolutionException;
import math.utils.Numerics;

public class Polynomial {
    private int deg;
    private double[] a;

    public Polynomial(double c) {
        this.deg = 0;
        this.a = new double[1];
        this.a[0] = c;
    }

    public Polynomial(int deg, double[] b) {
        this.deg = deg;
        this.a = new double[deg + 1];
        for (int i = 0; i <= deg; ++i) {
            this.a[i] = b[i];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polynomial other = (Polynomial)obj;
        if (this.deg != other.deg) {
            return false;
        }
        for (int i = 0; i <= this.deg; ++i) {
            if (Numerics.doublesEqual(this.a[i], other.a[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.deg;
        hash = 89 * hash + Arrays.hashCode(this.a);
        return hash;
    }

    public double getCoeff(int i) {
        return this.a[i];
    }

    public int getDeg() {
        return this.deg;
    }

    public double value(double arg) {
        double res = this.a[this.deg];
        for (int i = this.deg - 1; i >= 0; --i) {
            res = res * arg + this.a[i];
        }
        return res;
    }

    public double solve(double beg, double end) throws NoSolutionException {
        return this.solve(beg, end, 0.0, 1.0E-10);
    }

    public double solve(double beg, double end, double y) throws NoSolutionException {
        return this.solve(beg, end, y, 1.0E-10);
    }

    private double solve(double beg, double end, double y, double eps) throws NoSolutionException {
        double v1 = this.value(beg) - y;
        double v2 = this.value(end) - y;
        if (v1 == 0.0) {
            return beg;
        }
        if (v2 == 0.0) {
            return end;
        }
        if (v1 * v2 > 0.0) {
            throw new NoSolutionException();
        }
        while (end - beg > eps) {
            double mid = 0.5 * (beg + end);
            double v = this.value(mid) - y;
            if (v == 0.0) {
                return mid;
            }
            if (v1 > 0.0 && v > 0.0 || v1 < 0.0 && v < 0.0) {
                beg = mid;
                v1 = v;
                continue;
            }
            end = mid;
        }
        return beg;
    }
}

