/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.InvalidParamsException;

public class Parameters {
    public final double h;
    public final double t;

    public Parameters(double h, double t) throws InvalidParamsException {
        this.h = h;
        this.t = t;
        this.ensureParamsOK();
    }

    private void ensureParamsOK() throws InvalidParamsException {
        if (this.t / this.h > 1.0E7) {
            throw new InvalidParamsException("Given parameters require " + String.format("%.0f", this.t / this.h) + " steps, which is to large number.");
        }
    }

    public int getNumberOfSteps() {
        return new Double(Math.ceil(this.t / this.h)).intValue();
    }
}

