/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.BackwardEuler;
import circle.Euler;
import circle.ImprovedEuler;
import circle.IncorrectEuler;
import circle.InvalidParamsException;
import circle.Method;
import circle.MidpointEuler;
import circle.Parameters;
import circle.RungeKutta4;
import circle.TrapezoidalRule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import plot.PlotProxy;

public class MainPanel
extends JPanel {
    private PropertyChangeSupport pcs;
    private Parameters params;
    private JLabel calcLabel;
    private JSpinner circles;
    private JButton draw;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JComboBox methods;
    private JPanel paramsContainer;
    private JPanel plotContainer;
    private JSpinner step;

    public MainPanel() {
        this.initComponents();
        this.pcs = new PropertyChangeSupport(this);
        this.plotContainer.setLayout(new BorderLayout());
        this.plotContainer.add(PlotProxy.getPanel());
        try {
            this.params = new Parameters(Math.pow(2.0, -4.0), Math.PI * 2);
        }
        catch (InvalidParamsException invalidParamsException) {
            // empty catch block
        }
        this.calcLabel.setVisible(false);
    }

    public Parameters getParams() {
        return this.params;
    }

    private boolean setParams() {
        double h = (Double)this.step.getValue();
        double t = (double)(2 * (Integer)this.circles.getValue()) * Math.PI;
        try {
            this.params = new Parameters(h, t);
        }
        catch (InvalidParamsException ex) {
            JOptionPane.showMessageDialog(this, "Could not draw due to the following error:\n " + ex.getMessage(), "Drawing error", 0);
            return false;
        }
        return true;
    }

    public Method getMethod() {
        String name = this.methods.getSelectedItem().toString();
        if (name.equalsIgnoreCase("Explicit Euler")) {
            return new Euler();
        }
        if (name.equalsIgnoreCase("Backward Euler")) {
            return new BackwardEuler();
        }
        if (name.equalsIgnoreCase("Improved Euler")) {
            return new ImprovedEuler();
        }
        if (name.equalsIgnoreCase("Midpoint Euler")) {
            return new MidpointEuler();
        }
        if (name.equalsIgnoreCase("Incorrect Euler")) {
            return new IncorrectEuler();
        }
        if (name.equalsIgnoreCase("Trapezoidal Rule")) {
            return new TrapezoidalRule();
        }
        if (name.equalsIgnoreCase("Runge-Kutta 4")) {
            return new RungeKutta4();
        }
        throw new RuntimeException("Method \"" + name + "\" not known.");
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void block(boolean b) {
        this.draw.setEnabled(!b);
        this.calcLabel.setVisible(b);
    }

    private void initComponents() {
        this.plotContainer = new JPanel();
        this.paramsContainer = new JPanel();
        this.jLabel1 = new JLabel();
        this.step = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.circles = new JSpinner();
        this.jLabel4 = new JLabel();
        this.methods = new JComboBox();
        this.draw = new JButton();
        this.jLabel5 = new JLabel();
        this.calcLabel = new JLabel();
        this.plotContainer.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout plotContainerLayout = new GroupLayout(this.plotContainer);
        this.plotContainer.setLayout(plotContainerLayout);
        plotContainerLayout.setHorizontalGroup(plotContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 405, Short.MAX_VALUE));
        plotContainerLayout.setVerticalGroup(plotContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.paramsContainer.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("h");
        this.step.setModel(new SpinnerNumberModel(0.05, 1.0E-4, 5.0, 0.001));
        this.jLabel2.setText("Step size:");
        this.jLabel3.setText("N");
        this.circles.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.jLabel4.setText("Method:");
        this.methods.setModel(new DefaultComboBoxModel<String>(new String[]{"Explicit Euler", "Incorrect Euler", "Backward Euler", "Improved Euler", "Midpoint Euler", "Trapezoidal Rule", "Runge-Kutta 4"}));
        this.draw.setText("Draw!");
        this.draw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.drawActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Number of circles:");
        this.calcLabel.setForeground(new Color(255, 0, 0));
        this.calcLabel.setText("Calculating...");
        GroupLayout paramsContainerLayout = new GroupLayout(this.paramsContainer);
        this.paramsContainer.setLayout(paramsContainerLayout);
        paramsContainerLayout.setHorizontalGroup(paramsContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paramsContainerLayout.createSequentialGroup().addGroup(paramsContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(paramsContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.step).addComponent(this.circles))).addComponent(this.draw, -1, -1, Short.MAX_VALUE).addComponent(this.methods, 0, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addGroup(paramsContainerLayout.createSequentialGroup().addGroup(paramsContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel4)).addGap(0, 0, Short.MAX_VALUE)).addGroup(paramsContainerLayout.createSequentialGroup().addComponent(this.calcLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        paramsContainerLayout.setVerticalGroup(paramsContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paramsContainerLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(paramsContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.step, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addGap(19, 19, 19).addGroup(paramsContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.circles, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.methods, -2, -1, -2).addGap(41, 41, 41).addComponent(this.draw).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calcLabel).addContainerGap(66, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.plotContainer, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paramsContainer, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotContainer, -1, -1, Short.MAX_VALUE).addComponent(this.paramsContainer, -1, -1, Short.MAX_VALUE));
    }

    private void drawActionPerformed(ActionEvent evt) {
        if (this.setParams()) {
            this.pcs.firePropertyChange("DrawClicked", null, null);
        }
    }
}

