/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plot.PlotObject;
import plot.PlotPoint;

public class PlotPanel
extends JPanel {
    private double minimalIntervalX = 0.01;
    private double minimalIntervalY = 0.01;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    JSpinner jsMinX;
    JSpinner jsMinY;
    JSpinner jsMaxX;
    JSpinner jsMaxY;
    private ArrayList<PlotObject> pobjects;
    private JPanel legend = new JPanel();
    private JPanel controls;
    private boolean showGrid;

    public PlotPanel() {
        this.legend.setLayout(new BoxLayout(this.legend, 1));
        this.createControls();
        this.pobjects = new ArrayList();
        this.minY = -1.0;
        this.minX = -1.0;
        this.maxY = 1.0;
        this.maxX = 1.0;
        this.showGrid = true;
        this.setBackground(Color.WHITE);
    }

    @Override
    public synchronized void paint(Graphics gr) {
        super.paint(gr);
        if (!this.pobjects.isEmpty()) {
            this.markAxes(gr);
        }
        for (PlotObject po : this.pobjects) {
            PlotPoint pp;
            gr.setColor(po.getColor());
            if (po.getSize() == 0) continue;
            if (po.getSize() == 1) {
                for (PlotPoint plotPoint : po) {
                    pp = this.translate(plotPoint);
                    gr.fillOval((int)(pp.x - 3.0), (int)(pp.y - 3.0), 6, 6);
                }
                continue;
            }
            if (po.getType() == PlotObject.Type.Lines) {
                PlotPoint prev = null;
                for (PlotPoint plotPoint : po) {
                    if (prev == null) {
                        prev = this.translate(plotPoint);
                        continue;
                    }
                    PlotPoint pp2 = this.translate(plotPoint);
                    gr.drawLine((int)prev.x, (int)prev.y, (int)pp2.x, (int)pp2.y);
                    prev = pp2;
                }
                continue;
            }
            if (po.getType() != PlotObject.Type.Points) continue;
            for (PlotPoint plotPoint : po) {
                pp = this.translate(plotPoint);
                gr.fillOval((int)pp.x - 3, (int)pp.y - 3, 6, 6);
            }
        }
    }

    public synchronized void addPlotObject(PlotObject po) {
        this.pobjects.add(po);
        this.addToLegend(po.getLabel(), po.getColor());
        if (this.pobjects.size() == 1) {
            this.resetLimits();
            this.resetSpinners();
        }
        this.repaint();
    }

    public void resetLimits() {
        this.minX = this.minX();
        this.minY = this.minY();
        this.maxX = this.maxX();
        this.maxY = this.maxY();
        this.validateIntervalX();
        this.validateIntervalY();
        if (this.minX == Double.POSITIVE_INFINITY || this.minX == Double.NaN) {
            this.minX = -1.0;
        }
        if (this.minX == Double.NEGATIVE_INFINITY) {
            this.minX = -100000.0;
        }
        if (this.minY == Double.POSITIVE_INFINITY || this.minY == Double.NaN) {
            this.minY = -1.0;
        }
        if (this.minY == Double.NEGATIVE_INFINITY) {
            this.minY = -100000.0;
        }
        if (this.maxX == Double.NEGATIVE_INFINITY || this.maxX == Double.NaN) {
            this.maxX = 1.0;
        }
        if (this.maxX == Double.POSITIVE_INFINITY) {
            this.maxX = 100000.0;
        }
        if (this.maxY == Double.NEGATIVE_INFINITY || this.maxY == Double.NaN) {
            this.maxY = 1.0;
        }
        if (this.maxY == Double.POSITIVE_INFINITY) {
            this.maxY = 100000.0;
        }
    }

    private void validateIntervalX() {
        if (this.maxX - this.minX < this.minimalIntervalX) {
            this.maxX = this.minX + this.minimalIntervalX;
            this.resetSpinners();
        }
    }

    private void validateIntervalY() {
        if (this.maxY - this.minY < this.minimalIntervalY) {
            this.maxY = this.minY + this.minimalIntervalY;
            this.resetSpinners();
        }
    }

    public JPanel getLegend() {
        return this.legend;
    }

    public synchronized void clear() {
        this.pobjects.clear();
        this.repaint();
    }

    public double minX() {
        if (this.pobjects.isEmpty()) {
            return -1.0;
        }
        double res = this.pobjects.get(0).minX();
        for (PlotObject po : this.pobjects) {
            double min = po.minX();
            if (!(res > min)) continue;
            res = min;
        }
        return res;
    }

    public double minY() {
        if (this.pobjects.isEmpty()) {
            return -1.0;
        }
        double res = this.pobjects.get(0).minY();
        for (PlotObject po : this.pobjects) {
            double min = po.minY();
            if (!(res > min)) continue;
            res = min;
        }
        return res;
    }

    public double maxX() {
        if (this.pobjects.isEmpty()) {
            return -1.0;
        }
        double res = this.pobjects.get(0).maxX();
        for (PlotObject po : this.pobjects) {
            double max = po.maxX();
            if (!(res < max)) continue;
            res = max;
        }
        return res;
    }

    public double maxY() {
        if (this.pobjects.isEmpty()) {
            return -1.0;
        }
        double res = this.pobjects.get(0).maxY();
        for (PlotObject po : this.pobjects) {
            double max = po.maxY();
            if (!(res < max)) continue;
            res = max;
        }
        return res;
    }

    public void setMinX(double d) {
        this.minX = d;
        this.validateIntervalX();
    }

    public void setMinY(double d) {
        this.minY = d;
        this.validateIntervalY();
    }

    public void setMaxX(double d) {
        this.maxX = d;
        this.validateIntervalX();
    }

    public void setMaxY(double d) {
        this.maxY = d;
        this.validateIntervalY();
    }

    public void showGrid(boolean b) {
        this.showGrid = b;
    }

    public JPanel getControls() {
        return this.controls;
    }

    public void resetSpinners() {
        this.jsMinX.setValue(this.minX);
        this.jsMaxX.setValue(this.maxX);
        this.jsMinY.setValue(this.minY);
        this.jsMaxY.setValue(this.maxY);
    }

    private void createControls() {
        JPanel jpMinX = new JPanel(new GridLayout(2, 0));
        JPanel jpMaxX = new JPanel(new GridLayout(2, 0));
        JPanel jpMinY = new JPanel(new GridLayout(2, 0));
        JPanel jpMaxY = new JPanel(new GridLayout(2, 0));
        this.jsMinX = new JSpinner(new SpinnerNumberModel(-1.0, -1000000.0, 1000000.0, 1000.0));
        this.jsMaxX = new JSpinner(new SpinnerNumberModel(1.0, -1000000.0, 1000000.0, 1000.0));
        this.jsMinY = new JSpinner(new SpinnerNumberModel(-1.0, -1000000.0, 1000000.0, 0.1));
        this.jsMaxY = new JSpinner(new SpinnerNumberModel(1.0, -1000000.0, 1000000.0, 0.1));
        this.jsMinX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlotPanel.this.minXChanged();
            }
        });
        this.jsMaxX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlotPanel.this.maxXChanged();
            }
        });
        this.jsMinY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlotPanel.this.minYChanged();
            }
        });
        this.jsMaxY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlotPanel.this.maxYChanged();
            }
        });
        jpMinX.add(new JLabel("Min X"));
        jpMinX.add(this.jsMinX);
        jpMaxX.add(new JLabel("Max X"));
        jpMaxX.add(this.jsMaxX);
        jpMinY.add(new JLabel("Min Y"));
        jpMinY.add(this.jsMinY);
        jpMaxY.add(new JLabel("Max Y"));
        jpMaxY.add(this.jsMaxY);
        final JCheckBox check = new JCheckBox("show gird", true);
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotPanel.this.showGrid(check.isSelected());
                PlotPanel.this.repaint();
            }
        });
        JPanel buttons = new JPanel();
        JButton reset = new JButton("Reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotPanel.this.resetLimits();
                PlotPanel.this.resetSpinners();
                PlotPanel.this.repaint();
            }
        });
        buttons.add(reset);
        this.controls = new JPanel(new GridLayout(0, 3, 10, 10));
        this.controls.add(jpMinX);
        this.controls.add(jpMaxX);
        this.controls.add(check);
        this.controls.add(jpMinY);
        this.controls.add(jpMaxY);
        this.controls.add(buttons);
    }

    private void minXChanged() {
        this.minX = (Double)this.jsMinX.getValue();
        if (this.maxX - this.minX < this.minimalIntervalX) {
            this.jsMinX.setValue(this.maxX - this.minimalIntervalX);
        }
        this.repaint();
    }

    private void maxXChanged() {
        this.maxX = (Double)this.jsMaxX.getValue();
        if (this.maxX - this.minX < this.minimalIntervalX) {
            this.jsMaxX.setValue(this.minX + this.minimalIntervalX);
        }
        this.repaint();
    }

    private void minYChanged() {
        this.minY = (Double)this.jsMinY.getValue();
        if (this.maxY - this.minY < this.minimalIntervalY) {
            this.jsMinY.setValue(this.maxY - this.minimalIntervalY);
        }
        this.repaint();
    }

    private void maxYChanged() {
        this.maxY = (Double)this.jsMaxY.getValue();
        if (this.maxY - this.minY < this.minimalIntervalY) {
            this.jsMaxY.setValue(this.minY + this.minimalIntervalY);
        }
        this.repaint();
    }

    private void setLimitsFromSpinners() {
        this.minX = (Double)this.jsMinX.getValue();
        this.maxX = (Double)this.jsMaxX.getValue();
        this.minY = (Double)this.jsMinY.getValue();
        this.maxY = (Double)this.jsMaxY.getValue();
        this.validateIntervalX();
        this.validateIntervalY();
    }

    private void addToLegend(String label, Color col) {
        JLabel jlabel = new JLabel(label);
        jlabel.setForeground(col);
        this.legend.add(jlabel);
    }

    private PlotPoint translate(PlotPoint pp) {
        int h = this.getSize().height;
        int w = this.getSize().width;
        double W = (this.maxX - this.minX) * 1.1;
        double H = (this.maxY - this.minY) * 1.1;
        double minx = this.minX - (this.maxX - this.minX) * 0.05;
        double miny = this.minY - (this.maxY - this.minY) * 0.05;
        double x = (pp.x - minx) * (double)w / W;
        double y = (pp.y - miny) * (double)h / H;
        y = (double)h - y;
        return new PlotPoint(x, y);
    }

    private void markAxes(Graphics gr) {
        double y;
        double x;
        gr.setColor(Color.LIGHT_GRAY);
        int h = this.getSize().height;
        int w = this.getSize().width;
        double W = (this.maxX - this.minX) * 1.1;
        double H = (this.maxY - this.minY) * 1.1;
        double minx = this.minX - (this.maxX - this.minX) * 0.05;
        double maxx = this.maxX + (this.maxX - this.minX) * 0.05;
        double miny = this.minY - (this.maxY - this.minY) * 0.05;
        double maxy = this.maxY + (this.maxY - this.minY) * 0.05;
        double interval = this.getInterval(W);
        Font font = new Font("Monospace", 0, 8 > h / 50 ? 8 : h / 50);
        gr.setFont(font);
        for (x = 0.0; x < minx; x += interval) {
        }
        while (x - interval > minx) {
            x -= interval;
        }
        while (x < maxx) {
            PlotPoint pp = this.translate(new PlotPoint(x, miny));
            if (this.showGrid) {
                gr.drawLine((int)pp.x, (int)pp.y, (int)pp.x, 0);
            } else {
                gr.drawLine((int)pp.x, (int)pp.y, (int)pp.x, (int)(pp.y - 5.0));
            }
            String str = Double.toString((double)Math.round(100.0 * x) / 100.0);
            gr.drawString(str, (int)(pp.x - 5.0), (int)(pp.y - 5.0));
            x += interval;
        }
        interval = this.getInterval(H);
        for (y = 0.0; y < miny; y += interval) {
        }
        while (y - interval > miny) {
            y -= interval;
        }
        while (y < maxy) {
            PlotPoint pp = this.translate(new PlotPoint(minx, y));
            if (this.showGrid) {
                gr.drawLine(0, (int)pp.y, w, (int)pp.y);
            } else {
                gr.drawLine(0, (int)pp.y, 5, (int)pp.y);
            }
            String str = Double.toString((double)Math.round(100.0 * y) / 100.0);
            gr.drawString(str, 5, (int)pp.y);
            y += interval;
        }
    }

    private double getInterval(double l) {
        double interval = 0.1;
        if (l >= 1.0) {
            int i = 0;
            while (l / interval > 10.0) {
                interval = i % 3 == 0 ? (interval *= 2.0) : (i % 3 == 1 ? (interval *= 2.5) : (interval *= 2.0));
                ++i;
            }
        } else if (l >= 0.001) {
            interval = 1.0E-5;
            int i = 0;
            while (l / interval > 10.0) {
                interval = i % 3 == 0 ? (interval *= 2.0) : (i % 3 == 1 ? (interval *= 2.5) : (interval *= 2.0));
                ++i;
            }
        } else {
            interval = 1.0E-5;
        }
        return interval;
    }
}

