/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.Function;
import numerics.Interval;
import numerics.Solver;
import numerics.UnsatisfiedConditionsException;

public class Bisection
implements Solver {
    private Function f;
    private double leftEnd;
    private double rightEnd;
    private double leftVal;
    private double rightVal;
    private double middleVal;
    private double targetVal;
    private double eps = 0.001;

    public Bisection() {
    }

    public Bisection(Function f) {
        this.f = f;
    }

    public Bisection(Function f, double eps) {
        this.f = f;
        this.eps = eps;
    }

    @Override
    public void setFunction(Function f) {
        this.f = f;
    }

    @Override
    public double findRoot(Interval i) throws UnsatisfiedConditionsException {
        return this.solve(i, 0.0);
    }

    @Override
    public double solve(Interval i, double y) throws UnsatisfiedConditionsException {
        this.initAuxValues(i, y);
        this.ensureSolveable();
        this.runMainLoop();
        return this.leftEnd;
    }

    private void initAuxValues(Interval i, double y) {
        this.leftEnd = i.beg;
        this.rightEnd = i.end;
        this.leftVal = this.f.eval(i.beg);
        this.rightVal = this.f.eval(i.end);
        this.targetVal = y;
    }

    private void ensureSolveable() throws UnsatisfiedConditionsException {
        if (this.sameSideOfTargetVal(this.leftVal, this.rightVal)) {
            throw new UnsatisfiedConditionsException();
        }
    }

    @Override
    public void setAccuracy(double eps) {
        this.eps = eps;
    }

    private void runMainLoop() {
        while (this.rightEnd - this.leftEnd > this.eps) {
            double middle = (this.leftEnd + this.rightEnd) / 2.0;
            this.middleVal = this.f.eval(middle);
            if (this.sameSideOfTargetVal(this.leftVal, this.middleVal)) {
                this.leftEnd = middle;
                this.leftVal = this.middleVal;
                continue;
            }
            this.rightEnd = middle;
            this.rightVal = this.middleVal;
        }
    }

    private boolean sameSideOfTargetVal(double x, double y) {
        return Math.signum(x - this.targetVal) == Math.signum(y - this.targetVal);
    }
}

