/*
 * Decompiled with CFR 0.152.
 */
package math.utils;

import java.util.Iterator;
import math.matrices.DimensionException;
import math.matrices.Matrix;
import math.matrices.NoCorrelationException;
import math.matrices.Vector;
import math.utils.Numerics;

public class Statistics {
    private Statistics() {
    }

    public static double cndf(double t) {
        return 0.5 * (1.0 + Statistics.erf(t / Math.sqrt(2.0)));
    }

    private static double erf(double x) {
        if (x < 0.0) {
            return -Statistics.erf(-x);
        }
        double p = 0.3275911;
        double a1 = 0.254829592;
        double a2 = -0.284496736;
        double a3 = 1.421413741;
        double a4 = -1.453152027;
        double a5 = 1.061405429;
        double t = 1.0 / (1.0 + p * x);
        double w = ((((a5 * t + a4) * t + a3) * t + a2) * t + a1) * t;
        return 1.0 - w * Math.exp(-x * x);
    }

    public static double mean(Vector v) {
        double sum = 0.0;
        for (int row = 1; row <= v.getRows(); ++row) {
            sum += v.get(row);
        }
        return sum / (double)v.getRows();
    }

    public static Vector mean(Matrix m) {
        Vector res = new Vector(m.getCols());
        for (int row = 1; row <= res.getRows(); ++row) {
            res.set(row, Statistics.mean(m.getCol(row)));
        }
        return res;
    }

    public static double var(Vector sample) {
        Statistics.ensureSampleHasMinimalSize(sample);
        int n = sample.getSize();
        double m = Statistics.mean(sample);
        double res = 0.0;
        Iterator i$ = sample.iterator();
        while (i$.hasNext()) {
            double el = (Double)i$.next();
            res += (el - m) * (el - m);
        }
        return res / (double)(n - 1);
    }

    public static Vector var(Matrix m) {
        Vector res = new Vector(m.getCols());
        for (int i = 1; i <= res.getSize(); ++i) {
            res.set(i, Statistics.var(m.getCol(i)));
        }
        return res;
    }

    private static void ensureSampleHasMinimalSize(Vector sample) {
        if (sample.getSize() < 2) {
            throw new DimensionException("Size of the sample should be at least 2");
        }
    }

    public static double cov(Vector s1, Vector s2) {
        Statistics.ensureSamplesHaveTheSameSize(s1, s2);
        Statistics.ensureSampleHasMinimalSize(s1);
        int n = s1.getSize();
        double m1 = Statistics.mean(s1);
        double m2 = Statistics.mean(s2);
        double res = 0.0;
        for (int row = 1; row <= s1.getRows(); ++row) {
            res += (s1.get(row) - m1) * (s2.get(row) - m2);
        }
        return res / (double)(n - 1);
    }

    private static void ensureSamplesHaveTheSameSize(Vector s1, Vector s2) {
        if (s1.getSize() != s2.getSize()) {
            throw new DimensionException("Size of the samples should be the same");
        }
    }

    public static Matrix cov(Matrix m) {
        Statistics.ensureSampleHasMinimalSize(m);
        int cols = m.getCols();
        Matrix res = new Matrix(cols, cols);
        Vector means = Statistics.mean(m);
        for (int i = 1; i <= cols; ++i) {
            for (int j = i; j <= cols; ++j) {
                Statistics.fillCovElement(m, res, means, i, j);
            }
        }
        return res;
    }

    private static void ensureSampleHasMinimalSize(Matrix m) {
        if (m.getRows() < 2) {
            throw new DimensionException("Size of the sample should be at least 2");
        }
    }

    private static void fillCovElement(Matrix data, Matrix cov, Vector means, int col1, int col2) {
        double sum = 0.0;
        for (int row = 1; row <= data.getRows(); ++row) {
            sum += (data.get(row, col1) - means.get(col1)) * (data.get(row, col2) - means.get(col2));
        }
        cov.set(col1, col2, sum / (double)(data.getRows() - 1));
        cov.set(col2, col1, sum / (double)(data.getRows() - 1));
    }

    public static double corr(Vector s1, Vector s2) {
        double var1 = Statistics.var(s1);
        double var2 = Statistics.var(s2);
        Statistics.ensureCorrelationExists(new Vector(new double[]{var1, var2}));
        double cov = Statistics.cov(s1, s2);
        return cov / Math.sqrt(var1 * var2);
    }

    private static void ensureCorrelationExists(Vector variances) {
        for (int i = 1; i <= variances.getSize(); ++i) {
            if (!Numerics.isZero(variances.get(i))) continue;
            throw new NoCorrelationException("Sample " + i + " has zero variance");
        }
    }

    public static Matrix corr(Matrix m) {
        Vector vars = Statistics.var(m);
        Statistics.ensureCorrelationExists(vars);
        int cols = m.getCols();
        Matrix corr = Statistics.cov(m);
        for (int i = 1; i <= cols; ++i) {
            for (int j = 1; j <= cols; ++j) {
                corr.set(i, j, corr.get(i, j) / Math.sqrt(vars.get(i) * vars.get(j)));
            }
        }
        return corr;
    }
}

