/*
 * Decompiled with CFR 0.152.
 */
package math.approx;

import java.util.Arrays;
import math.matrices.Vector;
import math.utils.Numerics;

public class Polynomial2 {
    private double[][] a;
    private int deg;

    public Polynomial2(double[] coef, int deg) {
        this.ensureCoefHasProperLength(coef, deg);
        this.deg = deg;
        this.a = new double[deg + 1][];
        int nextInd = 0;
        for (int i = 0; i <= deg; ++i) {
            this.a[i] = new double[deg - i + 1];
            for (int j = 0; j <= deg - i; ++j) {
                this.a[i][j] = coef[nextInd++];
            }
        }
    }

    public Polynomial2(Vector coef, int deg) {
        this.ensureCoefHasProperLength(coef, deg);
        this.deg = deg;
        this.a = new double[deg + 1][];
        int nextInd = 1;
        for (int i = 0; i <= deg; ++i) {
            this.a[i] = new double[deg - i + 1];
            for (int j = 0; j <= deg - i; ++j) {
                this.a[i][j] = coef.get(nextInd++);
            }
        }
    }

    public Polynomial2(double constant) {
        this.deg = 0;
        this.a = new double[1][1];
        this.a[0][0] = constant;
    }

    public int getDeg() {
        return this.deg;
    }

    public double value(double x, double y) {
        double x_pow = 1.0;
        double sum = 0.0;
        for (int i = 0; i <= this.deg; ++i) {
            sum += this.valueOfSubPolynomial(i, x_pow, y);
            x_pow *= x;
        }
        return sum;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polynomial2 other = (Polynomial2)obj;
        if (this.deg != other.deg) {
            return false;
        }
        return this.compareArrays(other);
    }

    private boolean compareArrays(Polynomial2 other) {
        double[][] b = other.a;
        if (this.a.length != b.length) {
            return false;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i].length != b[i].length) {
                return false;
            }
            for (int j = 0; j < this.a[i].length; ++j) {
                if (Numerics.doublesEqual(this.a[i][j], b[i][j], 0.001)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Arrays.deepHashCode((Object[])this.a);
        hash = 13 * hash + this.deg;
        return hash;
    }

    private double valueOfSubPolynomial(int xDeg, double x_pow, double y) {
        double subsum = 0.0;
        for (int j = this.deg - xDeg; j >= 0; --j) {
            subsum = subsum * y + this.a[xDeg][j];
        }
        return x_pow * subsum;
    }

    private void ensureCoefHasProperLength(double[] coef, int deg) {
        int l = (deg + 1) * (deg + 2) / 2;
        if (l != coef.length) {
            throw new IllegalArgumentException("Coefficients array should have length " + l);
        }
    }

    private void ensureCoefHasProperLength(Vector coef, int deg) {
        int l = (deg + 1) * (deg + 2) / 2;
        if (l != coef.getSize()) {
            throw new IllegalArgumentException("Coefficients array should have length " + l);
        }
    }
}

