/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.Method;
import circle.Parameters;
import circle.Points;

public class TrapezoidalRule
implements Method {
    private double x = 1.0;
    private double y = 0.0;
    private Points points;
    private Parameters p;

    @Override
    public Points run(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.p = params;
        this.initAuxVals();
        this.calculate();
        return this.points;
    }

    private void initAuxVals() {
        this.x = 1.0;
        this.y = 0.0;
        this.points = new Points();
        this.points.addPoint(this.x, this.y);
    }

    private void calculate() {
        int n = this.p.getNumberOfSteps();
        double h = this.p.h;
        double h2 = this.p.h * this.p.h;
        for (int i = 0; i < n; ++i) {
            double prevX = this.x;
            double prevY = this.y;
            this.x = (this.x - h * this.y - h2 * this.x / 4.0) / (1.0 + h2 / 4.0);
            this.y = h * (prevX + this.x) / 2.0 + this.y;
            this.points.addPoint(this.x, this.y);
        }
    }
}

