/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.Method;
import circle.Parameters;
import circle.Points;
import math.matrices.Vector;

public class RungeKutta4
implements Method {
    Vector y = new Vector(2);
    private Points points;
    private Parameters p;

    @Override
    public Points run(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.p = params;
        this.initAuxVals();
        this.calculate();
        return this.points;
    }

    private void initAuxVals() {
        this.y.set(1, 0.0);
        this.y.set(2, 1.0);
        this.points = new Points();
        this.points.addPoint(1.0, 0.0);
    }

    private Vector f(Vector v) {
        double up = v.get(2);
        double down = -v.get(1);
        return new Vector(new double[]{up, down});
    }

    private void calculate() {
        int n = this.p.getNumberOfSteps();
        double h = this.p.h;
        for (int i = 0; i < n; ++i) {
            Vector k1 = this.f(this.y).times(h);
            Vector k2 = this.f(this.y.add(k1.times(0.5))).times(h);
            Vector k3 = this.f(this.y.add(k2.times(0.5))).times(h);
            Vector k4 = this.f(this.y.add(k3)).times(h);
            Vector dy = k1.times(0.16666666666666666).add(k2.times(0.3333333333333333)).add(k3.times(0.3333333333333333)).add(k4.times(0.16666666666666666));
            this.y = this.y.add(dy);
            this.points.addPoint(this.y.get(2), this.y.get(1));
        }
    }
}

