/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.MainPanel;
import circle.Method;
import circle.Parameters;
import circle.Points;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import plot.PlotObject;
import plot.PlotProxy;

public class CircleApp
extends JFrame {
    MainPanel mainPanel;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CircleApp().setVisible(true);
            }
        });
    }

    public CircleApp() {
        this.setShit();
        this.setUpInterface();
        this.setMenu();
        PlotProxy.setOptionsPO(new PlotObject("Approximation", Color.RED, PlotObject.Type.Lines));
        this.draw();
    }

    private void setShit() {
        this.setTitle("Circle");
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
    }

    private void setMenu() {
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem quit = new JMenuItem("Quit");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircleApp.this.dispose();
            }
        });
        file.add(quit);
        bar.add(file);
        this.setJMenuBar(bar);
    }

    private void setUpInterface() {
        this.mainPanel = new MainPanel();
        this.mainPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CircleApp.this.draw();
            }
        });
        this.add(this.mainPanel);
    }

    private void draw() {
        final Parameters params = this.mainPanel.getParams();
        final Method method = this.mainPanel.getMethod();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                CircleApp.this.mainPanel.block(true);
                Points points = method.run(params);
                PlotProxy.plot(points.getXs(), points.getYs());
                PlotProxy.addPoints(CircleApp.this.getCircle());
                PlotProxy.resetLimits();
                CircleApp.this.mainPanel.block(false);
                return null;
            }
        }.execute();
    }

    private PlotObject getCircle() {
        PlotObject po = new PlotObject("", Color.BLUE, PlotObject.Type.Lines);
        for (int i = 0; i < 1000; ++i) {
            double t = (double)i / 500.0 * Math.PI;
            po.addPoint(Math.cos(t), Math.sin(t));
        }
        return po;
    }
}

