/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import plot.PlotPoint;

public class PlotObject
implements Iterable<PlotPoint> {
    private ArrayList<PlotPoint> points;
    private String label;
    private Color col;
    private Type type;

    public PlotObject() {
        this("", Color.BLACK, Type.Points);
    }

    public PlotObject(String label, Color col, Type type) {
        this.label = label;
        this.col = col;
        this.type = type;
        this.points = new ArrayList();
    }

    public PlotObject(PlotObject po) {
        this.label = po.label;
        this.col = po.col;
        this.type = po.type;
        this.points = new ArrayList();
        for (PlotPoint pp : po.points) {
            this.points.add(pp);
        }
    }

    @Override
    public Iterator<PlotPoint> iterator() {
        return new POIterator();
    }

    public void addPoint(PlotPoint p) {
        this.points.add(p);
    }

    public void addPoint(double x, double y) {
        this.points.add(new PlotPoint(x, y));
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setColor(Color col) {
        this.col = col;
    }

    public Color getColor() {
        return this.col;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.points.size();
    }

    public double minX() {
        if (this.points.isEmpty()) {
            return -1.0;
        }
        double min = this.points.get((int)0).x;
        for (PlotPoint pp : this.points) {
            if (!(pp.x < min)) continue;
            min = pp.x;
        }
        return min;
    }

    public double minY() {
        if (this.points.isEmpty()) {
            return -1.0;
        }
        double min = this.points.get((int)0).y;
        for (PlotPoint pp : this.points) {
            if (!(pp.y < min)) continue;
            min = pp.y;
        }
        return min;
    }

    public double maxX() {
        if (this.points.isEmpty()) {
            return 1.0;
        }
        double max = this.points.get((int)0).x;
        for (PlotPoint pp : this.points) {
            if (!(pp.x > max)) continue;
            max = pp.x;
        }
        return max;
    }

    public double maxY() {
        if (this.points.isEmpty()) {
            return 1.0;
        }
        double max = this.points.get((int)0).y;
        for (PlotPoint pp : this.points) {
            if (!(pp.y > max)) continue;
            max = pp.y;
        }
        return max;
    }

    public void clear() {
        this.points.clear();
    }

    public static enum Type {
        Lines,
        Points;

    }

    class POIterator
    implements Iterator<PlotPoint> {
        Iterator<PlotPoint> it;

        public POIterator() {
            this.it = PlotObject.this.points.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PlotPoint next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

