/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.ArrayList;
import math.matrices.Matrix;
import math.matrices.Vector;
import numerics.ODE;

public class RungeKutta {
    private Matrix A;
    private Vector b4;
    private Vector b5;
    private Vector c;
    private ODE ode;
    private double tol;
    private ArrayList<Vector> ys;
    private ArrayList<Double> xs;
    private Vector y;
    private double x;
    private int next;
    private int s;
    private Vector[] k;
    private double h;
    private double hmin = 1.220703125E-4;
    private final boolean controlStep;

    public RungeKutta(Matrix A, Vector b4, Vector b5, Vector c, boolean controlStep) {
        this.checkArgs(A, b4, b5, c);
        this.A = A;
        this.b4 = b4;
        this.b5 = b5;
        this.c = c;
        this.controlStep = controlStep;
        this.s = A.getRows();
        this.k = new Vector[this.s + 1];
    }

    public void solve(ODE ode, double tol) {
        this.ode = ode;
        this.tol = tol;
        this.prepare();
        this.solve();
    }

    public int getSteps() {
        return this.next;
    }

    public double getXAt(int step) {
        return this.xs.get(step);
    }

    public Vector getYAt(int step) {
        return this.ys.get(step);
    }

    private void solve() {
        for (int i = 0; i < 10000000; ++i) {
            this.updateCoefs();
            this.x += this.h;
            this.y = this.calcNewY5();
            this.xs.add(this.x);
            this.ys.add(this.y);
            ++this.next;
            if (!(this.x > this.ode.xn)) continue;
            return;
        }
    }

    private void prepare() {
        this.ys = new ArrayList();
        this.xs = new ArrayList();
        this.y = this.ode.y0;
        this.x = this.ode.x0;
        this.ys.add(this.y);
        this.xs.add(this.x);
        this.next = 1;
        this.h = 0.015625;
    }

    private void checkArgs(Matrix A, Vector b4, Vector b5, Vector c) {
        if (!A.isSquare() || A.getRows() != c.getRows() || A.getCols() != b4.getRows() || A.getCols() != b5.getRows()) {
            throw new RuntimeException("Invalid arguments");
        }
    }

    private void updateKs() {
        for (int i = 1; i <= this.s; ++i) {
            this.updateK(i);
        }
    }

    private void updateK(int i) {
        double x_tmp = this.x + this.c.get(i) * this.h;
        Vector y_tmp = new Vector(this.y);
        for (int j = 1; j < i; ++j) {
            y_tmp = y_tmp.add(this.k[j].times(this.h * this.A.get(i, j)));
        }
        this.k[i] = this.ode.f(x_tmp, y_tmp);
    }

    private Vector calcNewY4() {
        Vector newY = new Vector(this.y);
        for (int j = 1; j <= this.s; ++j) {
            newY = newY.add(this.k[j].times(this.h * this.b4.get(j)));
        }
        return newY;
    }

    private Vector calcNewY5() {
        Vector newY = new Vector(this.y);
        for (int j = 1; j <= this.s; ++j) {
            newY = newY.add(this.k[j].times(this.h * this.b5.get(j)));
        }
        return newY;
    }

    private void updateCoefs() {
        this.updateKs();
        if (this.controlStep) {
            this.updateH();
        }
    }

    private void updateH() {
        for (int i = 0; i < 10; ++i) {
            Vector y5;
            Vector y4 = this.calcNewY4();
            double norm = y4.add((y5 = this.calcNewY5()).times(-1.0)).norm();
            if (norm < this.tol && norm > this.tol / 4.0) {
                return;
            }
            double alfa = 0.8 * Math.pow(this.tol / norm, 0.2);
            this.h *= alfa;
            if (this.h < this.hmin) {
                this.h = this.hmin;
                this.updateKs();
                return;
            }
            this.updateKs();
        }
    }
}

