/*
 * Decompiled with CFR 0.152.
 */
package math.utils;

import java.util.Random;
import math.matrices.DimensionException;
import math.matrices.Matrix;
import math.matrices.NotPositiveDefiniteMatrixException;
import math.matrices.Vector;

public class RandomTools {
    private Random r = new Random(System.currentTimeMillis());

    public void setSeed(long seed) {
        this.r.setSeed(seed);
    }

    public int uniformInt(int n) {
        return this.r.nextInt(n);
    }

    public double uniform() {
        return this.r.nextDouble();
    }

    public Vector uniform(int n) {
        return this.uniform(n, 0.0, 1.0);
    }

    public double uniform(double a, double b) {
        if (a > b) {
            throw new IllegalArgumentException();
        }
        return (b - a) * this.uniform() + a;
    }

    public Vector uniform(int n, double a, double b) {
        Vector res = new Vector(n);
        for (int row = 1; row <= n; ++row) {
            res.set(row, this.uniform(a, b));
        }
        return res;
    }

    public double normal() {
        return this.r.nextGaussian();
    }

    public Vector normal(int n) {
        return this.normal(n, 0.0, 1.0);
    }

    public double normal(double mean, double var) {
        return mean + Math.sqrt(var) * this.normal();
    }

    public Vector normal(int n, double mean, double var) {
        Vector res = new Vector(n);
        for (int row = 1; row <= n; ++row) {
            res.set(row, this.normal(mean, var));
        }
        return res;
    }

    public Vector normal(Vector mean, Matrix covar) throws NotPositiveDefiniteMatrixException, DimensionException {
        if (mean.getRows() != covar.getRows()) {
            throw new DimensionException("Sizes of mean vector and covariation matrix are not consistent.");
        }
        Matrix L = covar.cholesky();
        return mean.add(L.mult(this.normal(mean.getRows())));
    }
}

