/*
 * Decompiled with CFR 0.152.
 */
package math.approx;

import math.approx.UnsupportedCaseException;
import math.matrices.Matrix;
import math.matrices.UninvertibleMatrixException;
import math.matrices.Vector;

public class Regresser {
    public Vector regress(Matrix X, Vector Y) throws UnsupportedCaseException {
        this.ensureRegressionArgsOK(X, Y);
        this.ensureAllColsExceptFirstAreNotConst(X);
        Matrix tr = X.transpose();
        try {
            return tr.mult(X).getInverted().mult(tr).mult(Y);
        }
        catch (UninvertibleMatrixException ex) {
            throw new UnsupportedCaseException();
        }
    }

    private void ensureAllColsExceptFirstAreNotConst(Matrix X) throws UnsupportedCaseException {
        for (int col = 2; col <= X.getCols(); ++col) {
            if (!this.isColConstant(X, col)) continue;
            throw new UnsupportedCaseException();
        }
    }

    private boolean isColConstant(Matrix X, int col) {
        double val = X.get(1, col);
        for (int row = 2; row <= X.getRows(); ++row) {
            if (!(Math.abs(val - X.get(row, col)) > 1.0E-4)) continue;
            return false;
        }
        return true;
    }

    private void ensureRegressionArgsOK(Matrix X, Vector Y) {
        if (X.getRows() != Y.getRows()) {
            throw new IllegalArgumentException("Number of rows in X and Y differ");
        }
        if (X.getRows() < X.getCols()) {
            throw new IllegalArgumentException("Number of observations is smaller than number of predictors.");
        }
    }
}

