/*
 * Decompiled with CFR 0.152.
 */
package math.approx;

import math.approx.GaussAux;
import math.approx.InvalidArgumentException;
import math.approx.ManySolutionsException;
import math.approx.NoSolutionException;
import math.utils.Numerics;

public class Gauss {
    public double[] solve(double[][] system) throws NoSolutionException, ManySolutionsException {
        return this.solve(system, false);
    }

    public double[] solve(double[][] system, boolean modifySystem) throws NoSolutionException, ManySolutionsException {
        this.ensureSystemIsValid(system);
        Object systemCopy = system;
        if (!modifySystem) {
            systemCopy = new double[system.length][];
            for (int i = 0; i < system.length; ++i) {
                systemCopy[i] = (double[])system[i].clone();
            }
        }
        GaussAux aux = new GaussAux((double[][])systemCopy);
        this.toTriangle(aux);
        return this.fromTriangle(aux);
    }

    private void ensureSystemIsValid(double[][] system) {
        if (system == null) {
            throw new InvalidArgumentException("System can not be null");
        }
        if (system.length == 0) {
            throw new InvalidArgumentException("System must have at least one equation");
        }
        if (system[0] == null) {
            throw new InvalidArgumentException("System has nulls as equations");
        }
        int n = system[0].length;
        if (n < 2) {
            throw new InvalidArgumentException("Equation must be represented by at least two doubles");
        }
        for (int eq = 1; eq < system.length; ++eq) {
            if (system[eq] == null) {
                throw new InvalidArgumentException("System has nulls as equations");
            }
            if (system[eq].length == n) continue;
            throw new InvalidArgumentException("Equations' lengths differ");
        }
    }

    private void toTriangle(GaussAux aux) {
        int eq = 0;
        for (int var = 0; eq < aux.equations && var < aux.variables; ++var) {
            boolean ok = Gauss.rearrange(aux, eq, var);
            if (ok) {
                aux.eq4var[var] = eq;
                Gauss.subtract(aux, eq, var);
                ++eq;
                continue;
            }
            aux.eq4var[var] = -1;
        }
        if (eq < aux.equations) {
            aux.rowWithZeros = eq;
        }
    }

    private double[] fromTriangle(GaussAux aux) throws NoSolutionException, ManySolutionsException {
        this.ensureHasSolutions(aux);
        double[] result = new double[aux.variables];
        boolean oneSolution = true;
        for (int var = aux.variables - 1; var >= 0; --var) {
            int eq = aux.eq4var[var];
            if (eq < 0) {
                oneSolution = false;
                result[var] = 0.0;
                continue;
            }
            double res = aux.system[eq][aux.variables];
            for (int j = aux.variables - 1; j > var; --j) {
                res -= aux.system[eq][j] * result[j];
            }
            result[var] = res / aux.system[eq][var];
        }
        if (oneSolution) {
            return result;
        }
        throw new ManySolutionsException(result);
    }

    private static boolean rearrange(GaussAux aux, int eq, int var) {
        double[][] system = aux.system;
        if (!Numerics.isZero(system[eq][var])) {
            return true;
        }
        for (int j = eq + 1; j < aux.equations; ++j) {
            if (Numerics.isZero(system[j][var])) continue;
            double[] pom = system[eq];
            system[eq] = system[j];
            system[j] = pom;
            return true;
        }
        return false;
    }

    private static void subtract(GaussAux aux, int eq, int var) {
        double[][] system = aux.system;
        for (int j = eq + 1; j < aux.equations; ++j) {
            double scalar = system[j][var] / system[eq][var];
            system[j][var] = 0.0;
            for (int k = var + 1; k <= aux.variables; ++k) {
                double[] dArray = system[j];
                int n = k;
                dArray[n] = dArray[n] - scalar * system[eq][k];
            }
        }
    }

    private void ensureHasSolutions(GaussAux aux) throws NoSolutionException {
        for (int eq = aux.rowWithZeros; eq < aux.equations; ++eq) {
            if (Numerics.isZero(aux.system[eq][aux.variables])) continue;
            throw new NoSolutionException();
        }
    }

    private void print(double[][] system) {
        for (int i = 0; i < system.length; ++i) {
            for (int j = 0; j < system[i].length; ++j) {
                System.out.print(system[i][j] + " ");
            }
            System.out.println();
        }
    }
}

