/*
 * Decompiled with CFR 0.152.
 */
package math.approx;

import java.util.Collection;
import math.approx.Gauss;
import math.approx.InvalidArgumentException;
import math.approx.ManySolutionsException;
import math.approx.NoSolutionException;
import math.approx.Point;
import math.approx.Point3D;
import math.approx.Polynomial;
import math.approx.Polynomial2;
import math.approx.Regresser;
import math.approx.UnsupportedCaseException;
import math.matrices.Matrix;
import math.matrices.Vector;

public class Approx {
    public Polynomial approximate(Collection<Point> points, int m) {
        this.ensureArgsOK(points, m);
        Gauss gauss = new Gauss();
        if (points.size() <= m) {
            m = points.size() - 1;
        }
        double[] s = this.calculateS(points, m);
        double[] t = this.calculateT(points, m);
        double[][] system = new double[m + 1][m + 2];
        for (int i = 0; i <= m; ++i) {
            for (int j = 0; j <= m; ++j) {
                system[i][j] = s[i + j];
            }
            system[i][m + 1] = t[i];
        }
        try {
            double[] a = gauss.solve(system, true);
            return new Polynomial(m, a);
        }
        catch (ManySolutionsException ex) {
            return new Polynomial(m, ex.exampleSolution);
        }
        catch (NoSolutionException ex) {
            return this.approximate(points, m - 1);
        }
    }

    private void ensureArgsOK(Collection points, int m) {
        if (points == null) {
            throw new InvalidArgumentException("points can not be null");
        }
        if (points.isEmpty()) {
            throw new InvalidArgumentException("points can not be empty");
        }
        if (m < 0) {
            throw new InvalidArgumentException("degree can not be negative");
        }
    }

    private double[] calculateS(Collection<Point> points, int m) {
        double[] s = new double[2 * m + 1];
        for (int i = 0; i <= 2 * m; ++i) {
            s[i] = 0.0;
        }
        for (Point p : points) {
            double power = 1.0;
            int i = 0;
            while (i <= 2 * m) {
                int n = i++;
                s[n] = s[n] + power;
                power *= p.x;
            }
        }
        return s;
    }

    private double[] calculateT(Collection<Point> points, int m) {
        double[] t = new double[m + 1];
        for (int i = 0; i <= m; ++i) {
            t[i] = 0.0;
        }
        for (Point p : points) {
            double power = 1.0;
            int i = 0;
            while (i <= m) {
                int n = i++;
                t[n] = t[n] + power * p.y;
                power *= p.x;
            }
        }
        return t;
    }

    public Polynomial2 approximate2(Collection<Point3D> points, int m) {
        Vector b;
        this.ensureArgsOK(points, m);
        Matrix X = this.preparePredictorsForRegression(points, m);
        Vector Y = this.prepareObservationsForRegression(points);
        Regresser r = new Regresser();
        try {
            b = r.regress(X, Y);
        }
        catch (UnsupportedCaseException ex) {
            return new Polynomial2(Double.POSITIVE_INFINITY);
        }
        return new Polynomial2(b, m);
    }

    private Matrix preparePredictorsForRegression(Collection<Point3D> points, int m) {
        int n = (m + 1) * (m + 2) / 2;
        Matrix X = new Matrix(points.size(), n);
        int row = 1;
        for (Point3D p : points) {
            X.setRow(row, this.makePredictorsFromPoint(p, m));
            ++row;
        }
        return X;
    }

    private Vector makePredictorsFromPoint(Point3D p, int m) {
        int n = (m + 1) * (m + 2) / 2;
        Vector v = new Vector(n);
        int nextInd = 1;
        double x_pow = 1.0;
        for (int i = 0; i <= m; ++i) {
            double y_pow = 1.0;
            for (int j = 0; j <= m - i; ++j) {
                v.set(nextInd++, x_pow * y_pow);
                y_pow *= p.y;
            }
            x_pow *= p.x;
        }
        return v;
    }

    private Vector prepareObservationsForRegression(Collection<Point3D> points) {
        Vector Y = new Vector(points.size());
        int row = 1;
        for (Point3D p : points) {
            Y.set(row, p.z);
            ++row;
        }
        return Y;
    }
}

