/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.Method;
import circle.Parameters;
import circle.Points;

public class MidpointEuler
implements Method {
    private double x = 1.0;
    private double y = 0.0;
    private Points points;
    private Parameters p;

    @Override
    public Points run(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.p = params;
        this.initAuxVals();
        this.calculate();
        return this.points;
    }

    private void initAuxVals() {
        this.x = 1.0;
        this.y = 0.0;
        this.points = new Points();
        this.points.addPoint(this.x, this.y);
    }

    private void calculate() {
        int n = this.p.getNumberOfSteps();
        for (int i = 0; i < n; ++i) {
            double midY = this.y + 0.5 * this.p.h * this.x;
            double midX = this.x - 0.5 * this.p.h * this.y;
            this.y += this.p.h * midX;
            this.x -= this.p.h * midY;
            this.points.addPoint(this.x, this.y);
        }
    }
}

