/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.MainPanel;
import circle.Method;
import circle.Parameters;
import circle.Points;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JApplet;
import plot.PlotObject;
import plot.PlotProxy;

public class Circle
extends JApplet {
    MainPanel mainPanel;

    @Override
    public void init() {
        this.setUpInterface();
        PlotProxy.setOptionsPO(new PlotObject("Approximation", Color.RED, PlotObject.Type.Lines));
        this.draw();
    }

    private void setUpInterface() {
        this.mainPanel = new MainPanel();
        this.mainPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Circle.this.draw();
            }
        });
        this.add(this.mainPanel);
    }

    private void draw() {
        Parameters params = this.mainPanel.getParams();
        Method method = this.mainPanel.getMethod();
        Points points = method.run(params);
        PlotProxy.plot(points.getXs(), points.getYs());
        PlotProxy.addPoints(this.getCircle());
        PlotProxy.resetLimits();
        this.revalidate();
        this.repaint();
    }

    private PlotObject getCircle() {
        PlotObject po = new PlotObject("", Color.BLUE, PlotObject.Type.Lines);
        for (int i = 0; i < 1000; ++i) {
            double t = (double)i / 500.0 * Math.PI;
            po.addPoint(Math.cos(t), Math.sin(t));
        }
        return po;
    }
}

