/*
 * Decompiled with CFR 0.152.
 */
package circle;

import circle.Method;
import circle.Parameters;
import circle.Points;

public class BackwardEuler
implements Method {
    private double x = 1.0;
    private double y = 0.0;
    private Points points;
    private Parameters p;

    @Override
    public Points run(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.p = params;
        this.initAuxVals();
        this.calculate();
        return this.points;
    }

    private void initAuxVals() {
        this.x = 1.0;
        this.y = 0.0;
        this.points = new Points();
        this.points.addPoint(this.x, this.y);
    }

    private void calculate() {
        int n = this.p.getNumberOfSteps();
        double h = this.p.h;
        double h2 = this.p.h * this.p.h;
        for (int i = 0; i < n; ++i) {
            this.x = (this.x - h * this.y) / (1.0 + h2);
            this.y += h * this.x;
            this.points.addPoint(this.x, this.y);
        }
    }
}

