/*
 * Decompiled with CFR 0.152.
 */
package arenstorf;

import arenstorf.Arenstorf;
import arenstorf.ControlPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import plot.PlotProxy;

public class Main
extends JFrame {
    private ControlPanel controlPanel;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Main().setVisible(true);
            }
        });
    }

    Main() {
        this.setTitle("Arenstorf");
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setUpInterface();
    }

    private void setUpInterface() {
        this.setLayout(new BorderLayout());
        this.add((Component)PlotProxy.getPanel(), "Center");
        this.add(this.makeSouth(), "South");
    }

    private Component makeSouth() {
        this.controlPanel = new ControlPanel();
        this.controlPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Main.this.drawClicked();
            }
        });
        return this.controlPanel;
    }

    private void calculate() {
        Arenstorf a = new Arenstorf();
        a.calculate(this.controlPanel.getSimData());
        PlotProxy.plot(a.getPlotData());
        PlotProxy.resetLimits();
        this.controlPanel.drawEnabled(true);
    }

    private void drawClicked() {
        this.controlPanel.drawEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Main.this.calculate();
            }
        }).start();
    }
}

