/*
 * Decompiled with CFR 0.152.
 */
package arenstorf;

import arenstorf.SimData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanel
extends JPanel {
    private PropertyChangeSupport pcs;
    private JButton draw;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner mLogTol;
    private JSpinner time;
    private JLabel tolerance;

    public ControlPanel() {
        this.initComponents();
        this.pcs = new PropertyChangeSupport(this);
        this.setToleranceLabel();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public SimData getSimData() {
        return new SimData(this.getTolerance(), this.getTime());
    }

    public double getTime() {
        return (Double)this.time.getValue();
    }

    public double getTolerance() {
        return Math.pow(2.0, -((Integer)this.mLogTol.getValue()).intValue());
    }

    private void setToleranceLabel() {
        this.tolerance.setText(String.format("%6.3e", this.getTolerance()));
    }

    public void drawEnabled(boolean enabled) {
        this.draw.setEnabled(enabled);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.time = new JSpinner();
        this.mLogTol = new JSpinner();
        this.tolerance = new JLabel();
        this.draw = new JButton();
        this.jLabel1.setText("time");
        this.jLabel2.setText("-log(tolerance)");
        this.jLabel3.setText("tolerance: ");
        this.time.setModel(new SpinnerNumberModel(18.0, 1.0, 100.0, 0.5));
        this.mLogTol.setModel(new SpinnerNumberModel(20, 10, 40, 1));
        this.mLogTol.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ControlPanel.this.mLogTolStateChanged(evt);
            }
        });
        this.tolerance.setText("jLabel4");
        this.draw.setText("Draw");
        this.draw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.drawActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 134, Short.MAX_VALUE)).addComponent(this.jLabel3, -2, 118, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tolerance, -2, 115, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.time, -1, 74, Short.MAX_VALUE).addComponent(this.mLogTol)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 228, Short.MAX_VALUE).addComponent(this.draw, -2, 79, -2).addGap(98, 98, 98)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.time, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.mLogTol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.tolerance))).addGroup(layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.draw))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void drawActionPerformed(ActionEvent evt) {
        this.pcs.firePropertyChange("Draw clicked", 0, 1);
    }

    private void mLogTolStateChanged(ChangeEvent evt) {
        this.setToleranceLabel();
    }
}

