/*
 * Decompiled with CFR 0.152.
 */
package arenstorf;

import arenstorf.SimData;
import java.awt.Color;
import java.util.ArrayList;
import math.matrices.Vector;
import numerics.DormandPrince;
import numerics.ODE;
import numerics.RungeKutta;
import plot.PlotObject;

public class Arenstorf {
    private final Vector y0;
    private double mu1;
    private double mu2;
    private RungeKutta rk;
    private ODE ode;
    private double tol;
    private double time;

    public Arenstorf(double y1, double y2, double dy1, double dy2, double mu1) {
        this.y0 = new Vector(new double[]{y1, y2, dy1, dy2});
        this.mu1 = mu1;
        this.mu2 = 1.0 - mu1;
        this.rk = new DormandPrince().getMethod();
    }

    public Arenstorf() {
        this(0.994, 0.0, 0.0, -2.0015851063790824, 0.012277471);
    }

    public void calculate(SimData sd) {
        this.makeODE(sd.time);
        this.rk.solve(this.ode, sd.tolerance);
    }

    public PlotObject[] getPlotData() {
        ArrayList<PlotObject> pos = new ArrayList<PlotObject>();
        int ind = 0;
        int rot = 0;
        while (true) {
            PlotObject po = this.initPlotObjectForNextRotation(rot);
            ind = this.insertPointsFromOneRotation(ind, (double)(rot + 1) * 17.07, po);
            if (po.getSize() == 0) break;
            pos.add(po);
            ++rot;
        }
        return this.plotObjectsToArray(pos);
    }

    private PlotObject[] plotObjectsToArray(ArrayList<PlotObject> pos) {
        PlotObject[] arr = new PlotObject[pos.size()];
        for (int i = 0; i < pos.size(); ++i) {
            arr[i] = pos.get(i);
        }
        return arr;
    }

    private int insertPointsFromOneRotation(int ind, double time, PlotObject po) {
        for (int i = ind; i < this.rk.getSteps(); ++i) {
            double t = this.rk.getXAt(i);
            double x = this.rk.getYAt(i).get(1);
            double y = this.rk.getYAt(i).get(2);
            if (t > time) {
                return i;
            }
            po.addPoint(x, y);
        }
        return this.rk.getSteps();
    }

    private PlotObject initPlotObjectForNextRotation(int rot) {
        if (rot == 0) {
            return new PlotObject("First rotation", Color.BLACK, PlotObject.Type.Points);
        }
        if (rot == 1) {
            return new PlotObject("Second rotation", Color.BLUE, PlotObject.Type.Points);
        }
        if (rot == 2) {
            return new PlotObject("Third rotation", Color.GREEN, PlotObject.Type.Points);
        }
        if (rot == 3) {
            return new PlotObject("Fourth rotation", Color.RED, PlotObject.Type.Points);
        }
        if (rot == 4) {
            return new PlotObject("Fifth rotation", Color.ORANGE, PlotObject.Type.Points);
        }
        return new PlotObject("Next rotation", Color.GRAY, PlotObject.Type.Points);
    }

    private void makeODE(double time) {
        this.ode = new ODE(0.0, time, this.y0){

            @Override
            public Vector f(double x, Vector y) {
                return Arenstorf.this.f(x, y);
            }
        };
    }

    private double sqr(double x) {
        return x * x;
    }

    private Vector f(double x, Vector y) {
        double y1 = y.get(1);
        double y2 = y.get(2);
        double y3 = y.get(3);
        double y4 = y.get(4);
        double D1 = Math.pow(this.sqr(y1 + this.mu1) + this.sqr(y2), 1.5);
        double D2 = Math.pow(this.sqr(y1 - this.mu2) + this.sqr(y2), 1.5);
        double dy1 = y3;
        double dy2 = y4;
        double dy3 = y1 + 2.0 * y4 - this.mu2 * (y1 + this.mu1) / D1 - this.mu1 * (y1 - this.mu2) / D2;
        double dy4 = y2 - 2.0 * y3 - this.mu2 * y2 / D1 - this.mu1 * y2 / D2;
        return new Vector(new double[]{dy1, dy2, dy3, dy4});
    }
}

