function yi = TableLookBin(x, y, xx)
n = length(x);
if xx < x(1) | xx > x(n)
  error('Interpolation outside range')
end
% binary search
iL = 1; iU = n;
while (1)
  if iU - iL <= 1, break, end
  iM = fix((iL + iU) / 2);
  if x(iM) < xx
    iL = iM;
  else
    iU = iM;
  end
end
% linear interpolation
yi = y(iL) + (y(iL+1)-y(iL))/(x(iL+1)-x(iL))*(xx - x(iL));