/********************************************************************
 * BaseGLIB   Andrzej Lukaszewski
 *
 * Varia Skeletons 
 *
 ********************************************************************/

class ARGB // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
{
public:
   ARGB(AReal R=0, AReal G=0, AReal B=0){V[0]=R; V[1]=G; V[2]=B;}
   AReal R() const { return V[0]; }
   AReal G() const { return V[1]; }
   AReal B() const { return V[2]; }
   AReal operator[](int n) const { return V[n]; }
private:   
   AReal V[3];
};

class AMaterial // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
{
public:
   AMaterial (){};
   AMaterial (AReal R, AReal G, AReal B, ABool light=Afalse);
   ARGB kd, ks;
   ARGB em;     // emmitance
   AReal m;     // roughness
   int  phong;  // phong exponent
   ABool islight;
};

class ACamera // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
{
public:
   ACamera (AVector3 eye, AVector3 lookat, AVector3 up,
 	    AReal xview = 0.5, AReal yview = 0.5);
   ARay Ray(AReal x, AReal y) const;  // x,y from [0,1]
	   
private:
   AVector3 eye, bottomleft, xspan, yspan;
};

class ARay // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
{
public:
   ARay (AVector3 &pt, AVector3 &dir);
   ARay (const AVector3 &pt, const AVector3 &dir);
   AVector3 P() const { return p; }
   AVector3 D() const { return d; }
   AVector3 R(AReal t) const { return p+t*d; }
   
private:
   AVector3 p,d;   
};

class AIntersection // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
{
 public:
   AIntersection(){};
   
   AReal t;
   ABool hit;
   AMaterial *m;
      
   AVector3  p,n;
};

class AScene // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
{
public:
   AScene (); 
   Load(char *filename);
   ABool Intersect (ARay r, AIntersection &is);     
   ABool Unoccluded(ARay r);
//.....
};

