;; Wojciech Jedynak (wjedynak@gmail.com)

;; Bonus 2: In this file we show how to encode a language with
;; binders using the lambda calculus as an example.

;; This is a minimal example, for more consult the Redex tutorial:
;; http://docs.racket-lang.org/redex/tutorial.html

(require redex)

;;-------------------------------------------------------------------
;; Part 01: The language (L for lambda)
;;-------------------------------------------------------------------

;; The untyped lambda calculus

(define-language L
  (e (e e)                              ; application
     (lam x e)
     x)
  (x variable-not-otherwise-mentioned))

;;-------------------------------------------------------------------
;; Part 02: The reduction relation
;;-------------------------------------------------------------------

;; Contexts (unrestriced, we want general beta in this example)

(define-extended-language LC L
  (C hole
     (C e)
     (e C)))

;; Library file defining generic substitution
(collection-file-path "tut-subst.rkt" "redex")

;; Tutorial:
;; "That file contains the definition of the function subst/proc, which
;; expects four arguments: a predicate for determining if an expression
;; is a variable, a list of variables to replace, a list of terms to
;; replace them with, and a term to do the replacement inside (the
;; function has a hard-wired notion of the shape of all binding forms,
;; but is agnostic to the other expression forms in the language)."

(require redex/tut-subst)
(define-metafunction LC
  subst : x e e -> e
  [(subst x e_1 e_0)
   ,(subst/proc x? (list (term x)) (list (term e_1)) (term e_0))])
(define x? (redex-match LC x))

;; Reduction semantics

(define red
  (reduction-relation
   LC
   (--> (in-hole C ((lam x e_0) e_1))
        (in-hole C (subst x e_1 e_0))
        "beta")))

;; Examples

(traces red (term ((lam x x) (lam y y))))

;; diverding example: omega

(traces red (term ((lam x (x x)) (lam y (y y)))))
