module RegionsShallow where

type Point = (Double, Double)
type Vector = (Double, Double)
type Region = Point -> Bool

inRegion :: Point -> Region -> Bool
distance :: Point -> Point -> Double
empty :: Region
circle :: Region
square :: Region
outside :: Region -> Region
scale :: Vector -> Region -> Region
translate :: Vector -> Region -> Region
(/\) :: Region -> Region -> Region
(\/) :: Region -> Region -> Region

inRegion p r = r p
distance (x1, y1) (x2, y2) = sqrt $ (x1 - x2) ** 2 + (y1 - y2) ** 2
empty _ = False
circle p = distance p (0,0) <= 1
square (x,y) = abs x <= 1 && abs y <= 1
outside r p = not $ r p
scale (sx, sy) r (x, y) = r (x / sx, y / sy)
translate (dx, dy) r (x, y) = r (x - dx, y - dy)
(r1 /\ r2) p = r1 p && r2 p 
(r1 \/ r2) p = r1 p || r2 p 

circleAt :: Double -> Point -> Region
circleAt r center = translate center
                        $ scale (r, r) circle

circleRow :: Integer -> Region
circleRow n = foldr (\/) empty
                    [circleAt 1 (fromInteger x,0) | x <- [0..n-1]]


main = do
    let p = (0.0, 0.0) :: Point
    putStrLn $ show $
        p `inRegion` empty
    putStrLn $ show $
        (1.0, 0.0) `inRegion` circle
    putStrLn $ show $
        (1.5, 1.0) `inRegion` circle
    putStrLn $ show $
        (1.5, 1.0) `inRegion` (scale (2.0, 3.0) circle)
    putStrLn $ show $
        (1.0, 1.0) `inRegion` square
    putStrLn $ show $
        (1.0, 1.0) `inRegion` (translate (2.0, 3.0) square)
    putStrLn $ show $
        (0.0, 0.0) `inRegion` (square /\ (translate (1.0, 0.0) circle))
    putStrLn $ show $
        (1.0, 0.0) `inRegion` ((translate (-2.0, -5.0) square) \/ (scale (0.1, 0.2) circle))
    putStrLn $ show $
        (10, -20.0) `inRegion` (outside $ circleRow 100)
